/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.scaffolding;

import grails.gorm.api.GormAllOperations;
import grails.plugin.scaffolding.GormService;
import grails.util.Environment;
import grails.util.Holders;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.grails.datastore.gorm.GormEntity;
import org.springframework.context.ApplicationContext;

public final class DomainServiceLocator {
    private static final ConcurrentMap<Class<?>, GormService<?>> CACHE = new ConcurrentHashMap();

    private DomainServiceLocator() {
    }

    public static <T extends GormEntity<T>> GormService<T> resolve(Class<T> domainClass) {
        GormService cached;
        if (!Environment.isDevelopmentMode() && (cached = (GormService)CACHE.get(domainClass)) != null) {
            return cached;
        }
        GormService<T> found = DomainServiceLocator.findService(domainClass);
        if (!Environment.isDevelopmentMode()) {
            CACHE.put(domainClass, found);
        }
        return found;
    }

    public static void clear() {
        CACHE.clear();
    }

    private static <T extends GormEntity<T>> GormService<T> findService(Class<T> domainClass) {
        ApplicationContext ctx = Holders.getGrailsApplication().getMainContext();
        String[] names = ctx.getBeanNamesForType(GormService.class);
        GormService match = null;
        ArrayList<String> matchingBeanNames = new ArrayList<String>();
        for (String name : names) {
            GormService svc;
            GormEntity ge;
            GormService gs = (GormService)ctx.getBean(name);
            GormAllOperations resource = gs.getResource();
            if (!(resource instanceof GormEntity) || !(ge = (GormEntity)resource).instanceOf(domainClass)) continue;
            matchingBeanNames.add(name);
            if (match != null) {
                throw new IllegalStateException("Multiple GormService beans match domain " + domainClass.getName() + ": " + String.valueOf(matchingBeanNames));
            }
            match = svc = gs;
        }
        if (match == null) {
            throw new IllegalStateException("No GormService bean found for domain " + domainClass.getName() + " using resource.instanceOf(..). Scanned " + names.length + " GormService beans.");
        }
        return match;
    }
}

