/*
 * Decompiled with CFR 0.152.
 */
package org.apache.grails.web.layout;

import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.Decorator;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import groovy.text.Template;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.Map;
import org.apache.grails.web.layout.EmbeddedGrailsLayoutView;
import org.apache.grails.web.layout.GSPGrailsLayoutPage;
import org.grails.web.servlet.view.AbstractGrailsView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class SpringMVCViewDecorator
extends DefaultDecorator
implements Decorator {
    private View view;

    public SpringMVCViewDecorator(String name, View view) {
        super(name, view instanceof AbstractUrlBasedView ? ((AbstractUrlBasedView)view).getUrl() : view.toString(), Collections.emptyMap());
        this.view = view;
    }

    public void render(Content content, SiteMeshContext context) {
        SiteMeshWebAppContext ctx = (SiteMeshWebAppContext)context;
        this.render(content, Collections.emptyMap(), ctx.getRequest(), ctx.getResponse(), ctx.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Content content, Map<String, ?> model, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        block9: {
            HTMLPage htmlPage = GSPGrailsLayoutPage.content2htmlPage(content);
            request.setAttribute("__sitemesh__page", (Object)htmlPage);
            if (!response.isCommitted()) {
                boolean dispatched = false;
                try {
                    request.setAttribute(EmbeddedGrailsLayoutView.GSP_GRAILS_LAYOUT_PAGE, (Object)new GSPGrailsLayoutPage(true));
                    try {
                        this.view.render(model, request, response);
                        dispatched = true;
                        if (!response.isCommitted()) {
                            response.getWriter().flush();
                        }
                    }
                    catch (Exception e) {
                        this.cleanRequestAttributes(request);
                        String message = "Error applying layout : " + this.getName();
                        if (this.view instanceof AbstractGrailsView) {
                            ((AbstractGrailsView)this.view).rethrowRenderException((Throwable)e, message);
                            break block9;
                        }
                        throw new RuntimeException(message, e);
                    }
                }
                finally {
                    if (!dispatched) {
                        this.cleanRequestAttributes(request);
                    }
                }
            }
        }
        request.removeAttribute("__sitemesh__page");
        request.removeAttribute(EmbeddedGrailsLayoutView.GSP_GRAILS_LAYOUT_PAGE);
    }

    private void cleanRequestAttributes(HttpServletRequest request) {
        request.removeAttribute("org.grails.PAGE_SCOPE");
        request.removeAttribute("org.grails.layout.name");
    }

    public View getView() {
        return this.view;
    }

    public Template getTemplate() {
        if (this.view instanceof AbstractGrailsView) {
            return ((AbstractGrailsView)this.view).getTemplate();
        }
        return null;
    }
}

