/*
 * Decompiled with CFR 0.152.
 */
package org.apache.grails.web.layout;

import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.PageParserSelector;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.ContentProcessor;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import grails.web.mvc.GrailsResponseMutator;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import org.apache.grails.web.layout.EmbeddedGrailsLayoutView;
import org.apache.grails.web.layout.GSPGrailsLayoutPage;
import org.apache.grails.web.layout.GrailsPageResponseWrapper;
import org.grails.buffer.StreamCharBuffer;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.util.WebUtils;

public class GrailsContentBufferingResponse
extends HttpServletResponseWrapper
implements GrailsResponseMutator,
StreamCharBuffer.LazyInitializingWriter {
    private final GrailsPageResponseWrapper pageResponseWrapper;
    private final ContentProcessor contentProcessor;
    private final SiteMeshWebAppContext webAppContext;
    private boolean redirectCalled;

    public GrailsContentBufferingResponse(HttpServletResponse response, final ContentProcessor contentProcessor, final SiteMeshWebAppContext webAppContext) {
        super((HttpServletResponse)new GrailsPageResponseWrapper(webAppContext.getRequest(), response, new PageParserSelector(){

            public boolean shouldParsePage(String contentType) {
                return contentProcessor.handles(contentType);
            }

            public PageParser getPageParser(String contentType) {
                return null;
            }
        }){

            @Override
            public void setContentType(String contentType) {
                webAppContext.setContentType(contentType);
                super.setContentType(contentType);
            }
        });
        this.contentProcessor = contentProcessor;
        this.webAppContext = webAppContext;
        this.pageResponseWrapper = (GrailsPageResponseWrapper)this.getResponse();
        if (response.getContentType() != null) {
            webAppContext.setContentType(response.getContentType());
        }
    }

    public HttpServletResponse getTargetResponse() {
        return (HttpServletResponse)this.pageResponseWrapper.getResponse();
    }

    public boolean isUsingStream() {
        return this.pageResponseWrapper.isUsingStream();
    }

    public boolean isActive() {
        return this.pageResponseWrapper.isGrailsLayoutActive() || this.pageResponseWrapper.isGspGrailsLayoutActive();
    }

    public void deactivateGrailsLayout() {
        this.pageResponseWrapper.deactivateGrailsLayout();
    }

    public Content getContent() throws IOException {
        if (!this.pageResponseWrapper.isGrailsLayoutActive()) {
            return null;
        }
        GSPGrailsLayoutPage content = (GSPGrailsLayoutPage)((Object)this.webAppContext.getRequest().getAttribute(EmbeddedGrailsLayoutView.GSP_GRAILS_LAYOUT_PAGE));
        if (content != null && content.isUsed()) {
            return content;
        }
        char[] data = this.pageResponseWrapper.getContents();
        if (data != null && this.webAppContext.getContentType() != null) {
            return this.contentProcessor.build(data, (SiteMeshContext)this.webAppContext);
        }
        return null;
    }

    public void sendError(int sc) throws IOException {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        try {
            if (!this.redirectCalled && !this.isCommitted()) {
                super.sendError(sc);
            }
        }
        finally {
            if (webRequest != null) {
                WebUtils.storeGrailsWebRequest((GrailsWebRequest)webRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(int sc, String msg) throws IOException {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        try {
            if (!this.redirectCalled && !this.isCommitted()) {
                super.sendError(sc, msg);
            }
        }
        finally {
            if (webRequest != null) {
                WebUtils.storeGrailsWebRequest((GrailsWebRequest)webRequest);
            }
        }
    }

    public void sendRedirect(String location) throws IOException {
        this.redirectCalled = true;
        super.sendRedirect(location);
    }

    public void deactivateResponseMutator() {
        this.deactivateGrailsLayout();
    }
}

