/*
 * Decompiled with CFR 0.152.
 */
package org.grails.databinding.converters;

import grails.core.GrailsApplication;
import grails.databinding.TypedStructuredBindingEditor;
import grails.databinding.converters.FormattedValueConverter;
import grails.databinding.converters.ValueConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.grails.databinding.converters.CurrencyValueConverter;
import org.grails.databinding.converters.DateConversionHelper;
import org.grails.databinding.converters.Jsr310ConvertersConfiguration;
import org.grails.databinding.converters.LocalDateTimeConverter;
import org.grails.databinding.converters.TimeZoneConverter;
import org.grails.databinding.converters.UUIDConverter;
import org.grails.databinding.converters.web.LocaleAwareBigDecimalConverter;
import org.grails.databinding.converters.web.LocaleAwareNumberConverter;
import org.grails.plugins.databinding.DataBindingConfigurationProperties;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.LocaleResolver;

@Configuration
public class DefaultConvertersConfiguration {
    private final DataBindingConfigurationProperties configurationProperties;
    private final LocaleResolver localResolver;
    private final Jsr310ConvertersConfiguration jsr310ConvertersConfiguration;

    public DefaultConvertersConfiguration(GrailsApplication grailsApplication, DataBindingConfigurationProperties configurationProperties) {
        LocaleResolver localResolver;
        this.configurationProperties = configurationProperties;
        this.jsr310ConvertersConfiguration = new Jsr310ConvertersConfiguration(configurationProperties);
        try {
            localResolver = (LocaleResolver)grailsApplication.getMainContext().getBean(LocaleResolver.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            localResolver = null;
        }
        this.localResolver = localResolver;
    }

    @Bean(value={"defaultCurrencyConverter"})
    protected CurrencyValueConverter defaultCurrencyConverter() {
        return new CurrencyValueConverter();
    }

    @Bean(value={"defaultGrailsBigDecimalConverter"})
    protected ValueConverter defaultGrailsBigDecimalConverter() {
        LocaleAwareBigDecimalConverter converter = new LocaleAwareBigDecimalConverter();
        converter.setTargetType(BigDecimal.class);
        converter.setLocaleResolver(this.localResolver);
        return converter;
    }

    @Bean(value={"offsetDateTimeConverter"})
    FormattedValueConverter offsetDateTimeConverter() {
        return this.jsr310ConvertersConfiguration.offsetDateTimeConverter();
    }

    @Bean(value={"offsetDateTimeValueConverter"})
    ValueConverter offsetDateTimeValueConverter() {
        return this.jsr310ConvertersConfiguration.offsetDateTimeValueConverter();
    }

    @Bean(value={"offsetDateTimeStructuredBindingEditor"})
    TypedStructuredBindingEditor offsetDateTimeStructuredBindingEditor() {
        return this.jsr310ConvertersConfiguration.offsetDateTimeStructuredBindingEditor();
    }

    @Bean(value={"offsetTimeConverter"})
    FormattedValueConverter offsetTimeConverter() {
        return this.jsr310ConvertersConfiguration.offsetTimeConverter();
    }

    @Bean(value={"offsetTimeValueConverter"})
    ValueConverter offsetTimeValueConverter() {
        return this.jsr310ConvertersConfiguration.offsetTimeValueConverter();
    }

    @Bean(value={"offsetTimeStructuredBindingEditor"})
    TypedStructuredBindingEditor offsetTimeStructuredBindingEditor() {
        return this.jsr310ConvertersConfiguration.offsetTimeStructuredBindingEditor();
    }

    @Bean(value={"localDateTimeConverter"})
    FormattedValueConverter localDateTimeConverter() {
        return this.jsr310ConvertersConfiguration.localDateTimeConverter();
    }

    @Bean(value={"localDateTimeValueConverter"})
    ValueConverter localDateTimeValueConverter() {
        return this.jsr310ConvertersConfiguration.localDateTimeValueConverter();
    }

    @Bean(value={"localDateTimeStructuredBindingEditor"})
    TypedStructuredBindingEditor localDateTimeStructuredBindingEditor() {
        return this.jsr310ConvertersConfiguration.localDateTimeStructuredBindingEditor();
    }

    @Bean(value={"localDateConverter"})
    FormattedValueConverter localDateConverter() {
        return this.jsr310ConvertersConfiguration.localDateConverter();
    }

    @Bean(value={"localDateValueConverter"})
    ValueConverter localDateValueConverter() {
        return this.jsr310ConvertersConfiguration.localDateValueConverter();
    }

    @Bean(value={"localDateStructuredBindingEditor"})
    TypedStructuredBindingEditor localDateStructuredBindingEditor() {
        return this.jsr310ConvertersConfiguration.localDateStructuredBindingEditor();
    }

    @Bean(value={"localTimeConverter"})
    FormattedValueConverter localTimeConverter() {
        return this.jsr310ConvertersConfiguration.localTimeConverter();
    }

    @Bean(value={"localTimeValueConverter"})
    ValueConverter localTimeValueConverter() {
        return this.jsr310ConvertersConfiguration.localTimeValueConverter();
    }

    @Bean(value={"localTimeStructuredBindingEditor"})
    TypedStructuredBindingEditor localTimeStructuredBindingEditor() {
        return this.jsr310ConvertersConfiguration.localTimeStructuredBindingEditor();
    }

    @Bean(value={"zonedDateTimeConverter"})
    FormattedValueConverter zonedDateTimeConverter() {
        return this.jsr310ConvertersConfiguration.zonedDateTimeConverter();
    }

    @Bean(value={"zonedDateTimeValueConverter"})
    ValueConverter zonedDateTimeValueConverter() {
        return this.jsr310ConvertersConfiguration.zonedDateTimeValueConverter();
    }

    @Bean(value={"zonedDateTimeStructuredBindingEditor"})
    TypedStructuredBindingEditor zonedDateTimeStructuredBindingEditor() {
        return this.jsr310ConvertersConfiguration.zonedDateTimeStructuredBindingEditor();
    }

    @Bean(value={"periodValueConverter"})
    ValueConverter periodValueConverter() {
        return this.jsr310ConvertersConfiguration.periodValueConverter();
    }

    @Bean(value={"instantStringValueConverter"})
    ValueConverter instantStringValueConverter() {
        return this.jsr310ConvertersConfiguration.instantStringValueConverter();
    }

    @Bean(value={"instantValueConverter"})
    ValueConverter instantValueConverter() {
        return this.jsr310ConvertersConfiguration.instantValueConverter();
    }

    @Bean(value={"instantStructuredBindingEditor"})
    TypedStructuredBindingEditor instantStructuredBindingEditor() {
        return this.jsr310ConvertersConfiguration.instantStructuredBindingEditor();
    }

    @Bean(value={"defaultUUIDConverter"})
    protected UUIDConverter defaultuuidConverter() {
        return new UUIDConverter();
    }

    @Bean(value={"defaultGrailsBigIntegerConverter"})
    protected ValueConverter defaultGrailsBigIntegerConverter() {
        LocaleAwareBigDecimalConverter converter = new LocaleAwareBigDecimalConverter();
        converter.setTargetType(BigInteger.class);
        converter.setLocaleResolver(this.localResolver);
        return converter;
    }

    @Bean(value={"defaultDateConverter"})
    protected DateConversionHelper defaultDateConverter() {
        DateConversionHelper converter = new DateConversionHelper();
        converter.setDateParsingLenient(this.configurationProperties.isDateParsingLenient());
        converter.setFormatStrings(this.configurationProperties.getDateFormats());
        return converter;
    }

    @Bean(value={"defaultLocalDateTimeConverter"})
    protected LocalDateTimeConverter defaultLocalDateTimeConverter() {
        return new LocalDateTimeConverter();
    }

    @Bean(value={"timeZoneConverter"})
    protected TimeZoneConverter defaultTimeZoneConverter() {
        return new TimeZoneConverter();
    }

    @Bean(value={"defaultShortConverter"})
    protected LocaleAwareNumberConverter shortConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Short.class);
        return converter;
    }

    @Bean(value={"defaultshortConverter"})
    protected LocaleAwareNumberConverter primitiveShortConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Short.TYPE);
        return converter;
    }

    @Bean(value={"defaultIntegerConverter"})
    protected LocaleAwareNumberConverter integerConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Integer.class);
        return converter;
    }

    @Bean(value={"defaultintConverter"})
    protected LocaleAwareNumberConverter primitiveIntConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Integer.TYPE);
        return converter;
    }

    @Bean(value={"defaultFloatConverter"})
    protected LocaleAwareNumberConverter floatConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Float.class);
        return converter;
    }

    @Bean(value={"defaultfloatConverter"})
    protected LocaleAwareNumberConverter primitiveFloattConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Float.TYPE);
        return converter;
    }

    @Bean(value={"defaultLongConverter"})
    protected LocaleAwareNumberConverter longConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Long.class);
        return converter;
    }

    @Bean(value={"defaultlongConverter"})
    protected LocaleAwareNumberConverter primitiveLongConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Long.TYPE);
        return converter;
    }

    @Bean(value={"defaultDoubleConverter"})
    protected LocaleAwareNumberConverter doubleConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Double.class);
        return converter;
    }

    @Bean(value={"defaultdoubleConverter"})
    protected LocaleAwareNumberConverter primitiveDoubleConverter() {
        LocaleAwareNumberConverter converter = new LocaleAwareNumberConverter();
        converter.setLocaleResolver(this.localResolver);
        converter.setTargetType(Double.TYPE);
        return converter;
    }
}

