/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugin.hibernate.support;

import grails.persistence.support.PersistenceContextInterceptor;
import grails.validation.DeferredBindingActions;
import java.sql.Connection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.grails.core.lifecycle.ShutdownOperations;
import org.grails.orm.hibernate.AbstractHibernateDatastore;
import org.grails.orm.hibernate.support.HibernateRuntimeUtils;
import org.grails.plugin.hibernate.support.SessionFactoryAwarePersistenceContextInterceptor;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernatePersistenceContextInterceptor
implements PersistenceContextInterceptor,
SessionFactoryAwarePersistenceContextInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(HibernatePersistenceContextInterceptor.class);
    private AbstractHibernateDatastore hibernateDatastore;
    private static ThreadLocal<Map<String, Boolean>> participate = ThreadLocal.withInitial(HashMap::new);
    private static ThreadLocal<Map<String, Integer>> nestingCount = ThreadLocal.withInitial(HashMap::new);
    private String dataSourceName;
    private Deque<Connection> disconnected = new ConcurrentLinkedDeque<Connection>();
    private final boolean transactionRequired;

    public HibernatePersistenceContextInterceptor() {
        this("DEFAULT");
    }

    public HibernatePersistenceContextInterceptor(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        this.transactionRequired = true;
    }

    public void destroy() {
        DeferredBindingActions.clear();
        if (!this.disconnected.isEmpty()) {
            this.disconnected.pop();
        }
        if (this.getSessionFactory() == null || this.decNestingCount() > 0 || this.getParticipate()) {
            return;
        }
        SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        LOG.debug("Closing single Hibernate session in GrailsDispatcherServlet");
        try {
            this.disconnected.clear();
            SessionFactoryUtils.closeSession((Session)holder.getSession());
        }
        catch (RuntimeException ex) {
            LOG.error("Unexpected exception on closing Hibernate Session", (Throwable)ex);
        }
    }

    public void disconnect() {
        if (this.getSessionFactory() == null) {
            return;
        }
        try {
            this.disconnected.add(this.getSession(false).disconnect());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reconnect() {
        if (this.getSessionFactory() == null) {
            return;
        }
        Session session = this.getSession();
        if (!session.isConnected() && !this.disconnected.isEmpty()) {
            try {
                Connection connection = this.disconnected.peekLast();
                this.getSession().reconnect(connection);
            }
            catch (IllegalStateException e) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void flush() {
        if (this.getSessionFactory() == null) {
            return;
        }
        if (!this.getParticipate()) {
            if (!this.transactionRequired) {
                this.getSession().flush();
            } else if (TransactionSynchronizationManager.isSynchronizationActive()) {
                this.getSession().flush();
            }
        }
    }

    public void clear() {
        if (this.getSessionFactory() == null) {
            return;
        }
        this.getSession().clear();
    }

    public void setReadOnly() {
        if (this.getSessionFactory() == null) {
            return;
        }
        this.getSession().setHibernateFlushMode(FlushMode.MANUAL);
    }

    public void setReadWrite() {
        if (this.getSessionFactory() == null) {
            return;
        }
        this.getSession().setHibernateFlushMode(FlushMode.AUTO);
    }

    public boolean isOpen() {
        if (this.getSessionFactory() == null) {
            return false;
        }
        try {
            return this.getSession(false).isOpen();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void init() {
        if (this.incNestingCount() > 1) {
            return;
        }
        SessionFactory sf = this.getSessionFactory();
        if (sf == null) {
            return;
        }
        if (TransactionSynchronizationManager.hasResource((Object)sf)) {
            this.setParticipate(true);
        } else {
            this.setParticipate(false);
            LOG.debug("Opening single Hibernate session in HibernatePersistenceContextInterceptor");
            Session session = this.getSession();
            HibernateRuntimeUtils.enableDynamicFilterEnablerIfPresent((SessionFactory)sf, (Session)session);
            TransactionSynchronizationManager.bindResource((Object)sf, (Object)new SessionHolder(session));
        }
    }

    private Session getSession() {
        return this.getSession(true);
    }

    private Session getSession(boolean allowCreate) {
        Object value = TransactionSynchronizationManager.getResource((Object)this.getSessionFactory());
        if (value instanceof Session) {
            return (Session)value;
        }
        if (value instanceof SessionHolder) {
            SessionHolder sessionHolder = (SessionHolder)value;
            return sessionHolder.getSession();
        }
        if (allowCreate && this.hibernateDatastore != null) {
            return this.hibernateDatastore.openSession();
        }
        throw new IllegalStateException("No Hibernate Session bound to thread, and configuration does not allow creation of non-transactional one here");
    }

    public SessionFactory getSessionFactory() {
        return this.hibernateDatastore.getSessionFactory();
    }

    public void setHibernateDatastore(AbstractHibernateDatastore hibernateDatastore) {
        this.hibernateDatastore = hibernateDatastore;
    }

    @Override
    public void setSessionFactory(SessionFactory sessionFactory) {
    }

    private int incNestingCount() {
        Map<String, Integer> map = nestingCount.get();
        Integer current = map.get(this.dataSourceName);
        int value = current != null ? current + 1 : 1;
        map.put(this.dataSourceName, value);
        return value;
    }

    private int decNestingCount() {
        int value;
        Map<String, Integer> map = nestingCount.get();
        Integer current = map.get(this.dataSourceName);
        int n = value = current != null ? current - 1 : 0;
        if (value < 0) {
            value = 0;
        }
        map.put(this.dataSourceName, value);
        return value;
    }

    private void setParticipate(boolean flag) {
        Map<String, Boolean> map = participate.get();
        map.put(this.dataSourceName, flag);
    }

    private boolean getParticipate() {
        Map<String, Boolean> map = participate.get();
        Boolean ret = map.get(this.dataSourceName);
        return ret != null ? ret : false;
    }

    static {
        ShutdownOperations.addOperation(() -> {
            participate.remove();
            nestingCount.remove();
        });
    }
}

