/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.converters.marshaller.json;

import grails.converters.JSON;
import grails.persistence.PersistenceMethod;
import grails.web.controllers.ControllerMethod;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.grails.core.util.IncludeExcludeSupport;
import org.grails.web.converters.exceptions.ConverterException;
import org.grails.web.converters.marshaller.IncludeExcludePropertyMarshaller;
import org.grails.web.json.JSONWriter;
import org.springframework.beans.BeanUtils;

public class GenericJavaBeanMarshaller
extends IncludeExcludePropertyMarshaller<JSON> {
    @Override
    public boolean supports(Object object) {
        return true;
    }

    @Override
    public void marshalObject(Object o, JSON json) throws ConverterException {
        JSONWriter writer = json.getWriter();
        Class<?> clazz = o.getClass();
        List<String> excludes = json.getExcludes(clazz);
        List<String> includes = json.getIncludes(clazz);
        IncludeExcludeSupport includeExcludeSupport = new IncludeExcludeSupport();
        try {
            writer.object();
            for (PropertyDescriptor property : BeanUtils.getPropertyDescriptors(o.getClass())) {
                String name = property.getName();
                Method readMethod = property.getReadMethod();
                if (!this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, o, name) || readMethod == null || name.equals("metaClass") || name.equals("class") || Modifier.isStatic(readMethod.getModifiers()) || readMethod.getAnnotation(PersistenceMethod.class) != null || readMethod.getAnnotation(ControllerMethod.class) != null) continue;
                Object value = readMethod.invoke(o, (Object[])null);
                writer.key(name);
                json.convertAnother(value);
            }
            for (Field field : o.getClass().getDeclaredFields()) {
                String name;
                int modifiers = field.getModifiers();
                if (!field.isAccessible() || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || !this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, o, name = field.getName())) continue;
                writer.key(field.getName());
                json.convertAnother(field.get(o));
            }
            writer.endObject();
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Bean with class " + o.getClass().getName(), e);
        }
    }

    private boolean shouldInclude(IncludeExcludeSupport<String> includeExcludeSupport, List<String> includes, List<String> excludes, Object o, String name) {
        return includeExcludeSupport.shouldInclude(includes, excludes, (Object)name) && this.shouldInclude(o, name);
    }
}

