/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.converters.marshaller.json;

import grails.converters.JSON;
import grails.core.GrailsApplication;
import grails.core.support.proxy.DefaultProxyHandler;
import grails.core.support.proxy.EntityProxyHandler;
import grails.core.support.proxy.ProxyHandler;
import groovy.lang.GroovyObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.grails.core.util.IncludeExcludeSupport;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ManyToOne;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.web.converters.ConverterUtil;
import org.grails.web.converters.exceptions.ConverterException;
import org.grails.web.converters.marshaller.ByDatasourceDomainClassFetcher;
import org.grails.web.converters.marshaller.ByGrailsApplicationDomainClassFetcher;
import org.grails.web.converters.marshaller.DomainClassFetcher;
import org.grails.web.converters.marshaller.IncludeExcludePropertyMarshaller;
import org.grails.web.json.JSONWriter;
import org.springframework.beans.BeanWrapperImpl;

public class DomainClassMarshaller
extends IncludeExcludePropertyMarshaller<JSON> {
    private boolean includeVersion = false;
    private boolean includeClass = false;
    private ProxyHandler proxyHandler;
    private GrailsApplication application;
    private List<DomainClassFetcher> domainClassFetchers;

    public DomainClassMarshaller(boolean includeVersion, GrailsApplication application) {
        this(includeVersion, (ProxyHandler)new DefaultProxyHandler(), application);
        this.initializeDomainClassFetchers();
    }

    public DomainClassMarshaller(boolean includeVersion, ProxyHandler proxyHandler, GrailsApplication application) {
        this(includeVersion, false, proxyHandler, application);
        this.initializeDomainClassFetchers();
    }

    public DomainClassMarshaller(boolean includeVersion, boolean includeClass, ProxyHandler proxyHandler, GrailsApplication application) {
        this.includeVersion = includeVersion;
        this.includeClass = includeClass;
        this.proxyHandler = proxyHandler;
        this.application = application;
        this.initializeDomainClassFetchers();
    }

    private void initializeDomainClassFetchers() {
        this.domainClassFetchers = new ArrayList<DomainClassFetcher>(){
            {
                this.add(new ByGrailsApplicationDomainClassFetcher(DomainClassMarshaller.this.application));
                this.add(new ByDatasourceDomainClassFetcher());
            }
        };
    }

    public boolean isIncludeVersion() {
        return this.includeVersion;
    }

    public boolean isIncludeClass() {
        return this.includeClass;
    }

    public void setIncludeClass(boolean includeClass) {
        this.includeClass = includeClass;
    }

    public void setIncludeVersion(boolean includeVersion) {
        this.includeVersion = includeVersion;
    }

    @Override
    public boolean supports(Object object) {
        String name = ConverterUtil.trimProxySuffix(object.getClass().getName());
        return this.application.isArtefactOfType("Domain", name);
    }

    @Override
    public void marshalObject(Object value, JSON json) throws ConverterException {
        PersistentProperty versionProperty;
        Object version;
        Object idValue;
        PersistentEntity domainClass;
        JSONWriter writer = json.getWriter();
        value = this.proxyHandler.unwrapIfProxy(value);
        Class<?> clazz = value.getClass();
        List<String> excludes = json.getExcludes(clazz);
        List<String> includes = json.getIncludes(clazz);
        IncludeExcludeSupport includeExcludeSupport = new IncludeExcludeSupport();
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(value);
        writer.object();
        if (this.includeClass && this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, value, "class")) {
            writer.key("class").value((Object)clazz.getName());
        }
        if ((domainClass = this.findDomainClass(value)) == null) {
            throw new GrailsConfigurationException("Could not retrieve the respective entity for domain " + value.getClass().getName() + " in the mapping context API");
        }
        PersistentProperty id = domainClass.getIdentity();
        if (id != null && this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, value, id.getName()) && (idValue = this.extractValue(value, id)) != null) {
            json.property(id.getName(), idValue);
        }
        if (this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, value, "version") && this.isIncludeVersion() && (version = this.extractValue(value, versionProperty = domainClass.getVersion())) != null) {
            json.property("version", version);
        }
        List properties = domainClass.getPersistentProperties();
        for (PersistentProperty property : properties) {
            if (property.equals(domainClass.getVersion()) || !this.shouldInclude((IncludeExcludeSupport<String>)includeExcludeSupport, includes, excludes, value, property.getName())) continue;
            writer.key(property.getName());
            if (!(property instanceof Association)) {
                Object val = beanWrapper.getPropertyValue(property.getName());
                json.convertAnother(val);
                continue;
            }
            Cloneable referenceObject = beanWrapper.getPropertyValue(property.getName());
            if (this.isRenderDomainClassRelations()) {
                if (referenceObject == null) {
                    writer.valueNull();
                    continue;
                }
                if ((referenceObject = this.proxyHandler.unwrapIfProxy((Object)referenceObject)) instanceof SortedMap) {
                    referenceObject = new TreeMap(referenceObject);
                } else if (referenceObject instanceof SortedSet) {
                    referenceObject = new TreeSet((SortedSet)((Object)referenceObject));
                } else if (referenceObject instanceof Set) {
                    referenceObject = new LinkedHashSet((Set)((Object)referenceObject));
                } else if (referenceObject instanceof Map) {
                    referenceObject = new LinkedHashMap(referenceObject);
                } else if (referenceObject instanceof Collection) {
                    referenceObject = new ArrayList((Collection)((Object)referenceObject));
                }
                json.convertAnother(referenceObject);
                continue;
            }
            if (referenceObject == null) {
                json.value(null);
                continue;
            }
            PersistentEntity referencedDomainClass = ((Association)property).getAssociatedEntity();
            if (referencedDomainClass == null || ((Association)property).isEmbedded() || property.getType().isEnum()) {
                json.convertAnother(referenceObject);
                continue;
            }
            if (property instanceof OneToOne || property instanceof ManyToOne || ((Association)property).isEmbedded()) {
                this.asShortObject(referenceObject, json, referencedDomainClass.getIdentity(), referencedDomainClass);
                continue;
            }
            PersistentProperty referencedIdProperty = referencedDomainClass.getIdentity();
            String refPropertyName = ((Association)property).getReferencedPropertyName();
            if (referenceObject instanceof Collection) {
                Collection o = (Collection)((Object)referenceObject);
                writer.array();
                for (Object object : o) {
                    this.asShortObject(object, json, referencedIdProperty, referencedDomainClass);
                }
                writer.endArray();
                continue;
            }
            if (!(referenceObject instanceof Map)) continue;
            Map map = referenceObject;
            for (Map.Entry entry : map.entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object o = entry.getValue();
                writer.object();
                writer.key(key);
                this.asShortObject(o, json, referencedIdProperty, referencedDomainClass);
                writer.endObject();
            }
        }
        writer.endObject();
    }

    private PersistentEntity findDomainClass(Object value) {
        for (DomainClassFetcher fetcher : this.domainClassFetchers) {
            PersistentEntity domain = fetcher.findDomainClass(value);
            if (domain == null) continue;
            return domain;
        }
        return null;
    }

    private boolean shouldInclude(IncludeExcludeSupport<String> includeExcludeSupport, List<String> includes, List<String> excludes, Object object, String propertyName) {
        return includeExcludeSupport.shouldInclude(includes, excludes, (Object)propertyName) && this.shouldInclude(object, propertyName);
    }

    protected void asShortObject(Object refObj, JSON json, PersistentProperty idProperty, PersistentEntity referencedDomainClass) throws ConverterException {
        Object idValue;
        if (this.proxyHandler instanceof EntityProxyHandler) {
            idValue = ((EntityProxyHandler)this.proxyHandler).getProxyIdentifier(refObj);
            if (idValue == null) {
                idValue = this.extractValue(refObj, idProperty);
            }
        } else {
            idValue = this.extractValue(refObj, idProperty);
        }
        JSONWriter writer = json.getWriter();
        writer.object();
        if (this.isIncludeClass()) {
            writer.key("class").value((Object)referencedDomainClass.getName());
        }
        if (idValue != null) {
            writer.key("id").value(idValue);
        }
        writer.endObject();
    }

    protected Object extractValue(Object domainObject, PersistentProperty property) {
        if (property == null) {
            return null;
        }
        if (domainObject instanceof GroovyObject) {
            return ((GroovyObject)domainObject).getProperty(property.getName());
        }
        ClassPropertyFetcher propertyFetcher = ClassPropertyFetcher.forClass(domainObject.getClass());
        return propertyFetcher.getPropertyValue(domainObject, property.getName());
    }

    protected boolean isRenderDomainClassRelations() {
        return false;
    }
}

