/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import java.math.BigDecimal;
import org.grails.datastore.gorm.validation.constraints.AbstractConstraint;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;

public class ScaleConstraint
extends AbstractConstraint {
    private final int scale;

    public ScaleConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.scale = (Integer)this.constraintParameter;
    }

    @Override
    public boolean supports(Class type) {
        return type != null && (BigDecimal.class.isAssignableFrom(type) || ClassUtils.isAssignableOrConvertibleFrom(Float.class, (Class)type) || ClassUtils.isAssignableOrConvertibleFrom(Double.class, (Class)type));
    }

    @Override
    public String getName() {
        return "scale";
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Integer)) {
            throw new IllegalArgumentException("Parameter for constraint [" + this.getName() + "] of property [" + this.constraintPropertyName + "] of class [" + String.valueOf(this.constraintOwningClass) + "] must be a of type [java.lang.Integer]");
        }
        int requestedScale = (Integer)constraintParameter;
        if (requestedScale < 0) {
            throw new IllegalArgumentException("Parameter for constraint [" + this.getName() + "] of property [" + this.constraintPropertyName + "] of class [" + String.valueOf(this.constraintOwningClass) + "] must have a nonnegative value");
        }
        return constraintParameter;
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        BeanWrapperImpl bean = new BeanWrapperImpl(target);
        if (propertyValue instanceof Float) {
            BigDecimal bigDecimal = new BigDecimal(propertyValue.toString());
            bigDecimal = this.getScaledValue(bigDecimal);
            bean.setPropertyValue(this.getPropertyName(), (Object)Float.valueOf(bigDecimal.floatValue()));
        } else if (propertyValue instanceof Double) {
            BigDecimal bigDecimal = new BigDecimal(propertyValue.toString());
            bigDecimal = this.getScaledValue(bigDecimal);
            bean.setPropertyValue(this.getPropertyName(), (Object)bigDecimal.doubleValue());
        } else if (propertyValue instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)propertyValue;
            bigDecimal = this.getScaledValue(bigDecimal);
            bean.setPropertyValue(this.getPropertyName(), (Object)bigDecimal);
        } else {
            throw new IllegalArgumentException("Unsupported type detected in constraint [" + this.getName() + "] of property [" + this.constraintPropertyName + "] of class [" + String.valueOf(this.constraintOwningClass) + "]");
        }
    }

    private BigDecimal getScaledValue(BigDecimal originalValue) {
        if (originalValue.scale() > this.scale) {
            return originalValue.setScale(this.scale, 4);
        }
        return originalValue;
    }
}

