/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.troubleshooter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.gobblin.runtime.troubleshooter.Issue;
import org.apache.gobblin.runtime.troubleshooter.IssueRepository;
import org.apache.gobblin.runtime.troubleshooter.TroubleshooterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InMemoryIssueRepository
implements IssueRepository {
    private static final Logger log = LoggerFactory.getLogger(InMemoryIssueRepository.class);
    public static final int DEFAULT_MAX_SIZE = 100;
    private final LinkedHashMap<String, Issue> issues = new LinkedHashMap();
    private final int maxSize;
    private boolean reportedOverflow = false;

    @Inject
    public InMemoryIssueRepository() {
        this(100);
    }

    public InMemoryIssueRepository(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public synchronized List<Issue> getAll() throws TroubleshooterException {
        return new ArrayList<Issue>(this.issues.values());
    }

    @Override
    public synchronized void put(Issue issue) throws TroubleshooterException {
        if (this.issues.size() >= this.maxSize) {
            if (!this.reportedOverflow) {
                this.reportedOverflow = true;
                log.warn("In-memory issue repository has {} elements and is now full. New issues will be ignored.", (Object)this.issues.size());
            }
            return;
        }
        if (!this.issues.containsKey(issue.getCode())) {
            this.issues.put(issue.getCode(), issue);
        }
    }

    @Override
    public synchronized void put(Collection<Issue> issues) throws TroubleshooterException {
        for (Issue issue : issues) {
            this.put(issue);
        }
    }

    @Override
    public synchronized void remove(String code) throws TroubleshooterException {
        this.issues.remove(code);
    }

    @Override
    public synchronized void removeAll() throws TroubleshooterException {
        this.issues.clear();
    }

    @Override
    public synchronized void replaceAll(Collection<Issue> issues) throws TroubleshooterException {
        this.removeAll();
        this.put(issues);
    }
}

