/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.task;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.runtime.Task;
import org.apache.gobblin.runtime.TaskContext;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.TaskStateTracker;
import org.apache.gobblin.runtime.fork.Fork;
import org.apache.gobblin.runtime.task.TaskIFace;

public class TaskIFaceWrapper
extends Task {
    private final TaskIFace underlyingTask;
    private final TaskContext taskContext;
    private final String jobId;
    private final String taskId;
    private final CountDownLatch countDownLatch;
    private final TaskStateTracker taskStateTracker;
    private int retryCount = 0;

    public TaskIFaceWrapper(TaskIFace underlyingTask, TaskContext taskContext, CountDownLatch countDownLatch, TaskStateTracker taskStateTracker) {
        this.underlyingTask = underlyingTask;
        this.taskContext = taskContext;
        this.jobId = taskContext.getTaskState().getJobId();
        this.taskId = taskContext.getTaskState().getTaskId();
        this.countDownLatch = countDownLatch;
        this.taskStateTracker = taskStateTracker;
    }

    @Override
    public boolean awaitShutdown(long timeoutInMillis) throws InterruptedException {
        return this.underlyingTask.awaitShutdown(timeoutInMillis);
    }

    @Override
    public void shutdown() {
        this.underlyingTask.shutdown();
    }

    @Override
    public String getProgress() {
        return this.underlyingTask.getProgress();
    }

    @Override
    public void run() {
        try {
            this.underlyingTask.run();
        }
        finally {
            this.taskStateTracker.onTaskRunCompletion(this);
        }
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public TaskState getTaskState() {
        TaskState taskState = this.taskContext.getTaskState();
        taskState.setTaskId(this.getTaskId());
        taskState.setJobId(this.getJobId());
        taskState.setWorkingState(this.getWorkingState());
        taskState.addAll(this.getExecutionMetadata());
        taskState.addAll(this.getPersistentState());
        return taskState;
    }

    @Override
    public State getPersistentState() {
        return this.underlyingTask.getPersistentState();
    }

    @Override
    public State getExecutionMetadata() {
        return this.underlyingTask.getExecutionMetadata();
    }

    @Override
    public WorkUnitState.WorkingState getWorkingState() {
        return this.underlyingTask.getWorkingState();
    }

    @Override
    public List<Optional<Fork>> getForks() {
        return Lists.newArrayList();
    }

    @Override
    public void updateRecordMetrics() {
    }

    @Override
    public void updateByteMetrics() {
    }

    @Override
    public void incrementRetryCount() {
        ++this.retryCount;
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public void markTaskCompletion() {
        if (this.countDownLatch != null) {
            this.countDownLatch.countDown();
        }
    }

    @Override
    public String toString() {
        return this.underlyingTask.toString();
    }

    @Override
    public void commit() {
        this.underlyingTask.commit();
        this.taskStateTracker.onTaskCommitCompletion(this);
    }

    @Override
    protected void submitTaskCommittedEvent() {
    }

    @Override
    public boolean isSpeculativeExecutionSafe() {
        return this.underlyingTask.isSpeculativeExecutionSafe();
    }

    @Override
    public synchronized boolean cancel() {
        if (this.taskFuture != null && this.taskFuture.cancel(true)) {
            this.taskStateTracker.onTaskRunCompletion(this);
            return true;
        }
        return false;
    }
}

