/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.std;

import com.google.common.base.Optional;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.api.JobExecutionState;
import org.apache.gobblin.runtime.api.JobExecutionStateListener;
import org.slf4j.Logger;

public class DefaultJobExecutionStateListenerImpl
implements JobExecutionStateListener {
    protected final Optional<Logger> _log;

    public DefaultJobExecutionStateListenerImpl(Optional<Logger> log) {
        this._log = log;
    }

    public DefaultJobExecutionStateListenerImpl(Logger log) {
        this((Optional<Logger>)Optional.of((Object)log));
    }

    public DefaultJobExecutionStateListenerImpl() {
        this((Optional<Logger>)Optional.absent());
    }

    @Override
    public void onStatusChange(JobExecutionState state, JobState.RunningState previousStatus, JobState.RunningState newStatus) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("JobExection status change for " + state.getJobSpec().toShortString() + ": " + previousStatus + " --> " + newStatus);
        }
    }

    @Override
    public void onStageTransition(JobExecutionState state, String previousStage, String newStage) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("JobExection stage change for " + state.getJobSpec().toShortString() + ": " + previousStage + " --> " + newStage);
        }
    }

    @Override
    public void onMetadataChange(JobExecutionState state, String key, Object oldValue, Object newValue) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("JobExection metadata change for " + state.getJobSpec().toShortString() + key + ": '" + oldValue + "' --> '" + newValue + "'");
        }
    }
}

