/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_store;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.gobblin.broker.SharedResourcesBrokerFactory;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.metastore.MysqlDataSourceFactory;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.InstrumentedSpecStore;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.api.SpecSerDe;
import org.apache.gobblin.runtime.api.SpecSerDeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlBaseSpecStore
extends InstrumentedSpecStore {
    private static final Logger log = LoggerFactory.getLogger(MysqlBaseSpecStore.class);
    public static final String CONFIG_PREFIX = "mysqlBaseSpecStore";
    public static final String DEFAULT_TAG_VALUE = "";
    private static final String EXISTS_STATEMENT = "SELECT EXISTS(SELECT * FROM %s WHERE spec_uri = ?)";
    protected static final String INSERT_STATEMENT = "INSERT INTO %s (spec_uri, tag, spec) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE spec = VALUES(spec)";
    protected static final String UPDATE_STATEMENT = "UPDATE %s SET spec=?,spec_json=? WHERE spec_uri=? AND UNIX_TIMESTAMP(modified_time) < ?";
    private static final String DELETE_STATEMENT = "DELETE FROM %s WHERE spec_uri = ?";
    private static final String GET_STATEMENT_BASE = "SELECT spec_uri, spec FROM %s WHERE ";
    private static final String GET_ALL_STATEMENT = "SELECT spec_uri, spec, modified_time FROM %s";
    private static final String GET_ALL_URIS_STATEMENT = "SELECT spec_uri FROM %s";
    private static final String GET_ALL_URIS_WITH_TAG_STATEMENT = "SELECT spec_uri FROM %s WHERE tag = ?";
    private static final String GET_SPECS_BATCH_STATEMENT = "SELECT spec_uri, spec, modified_time FROM %s ORDER BY spec_uri ASC LIMIT ? OFFSET ?";
    private static final String GET_SIZE_STATEMENT = "SELECT COUNT(*) FROM %s ";
    private static final String CREATE_TABLE_STATEMENT = "CREATE TABLE IF NOT EXISTS %s (spec_uri VARCHAR(" + FlowSpec.Utils.maxFlowSpecUriLength() + ") NOT NULL, tag VARCHAR(128) NOT NULL, modified_time TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, spec LONGBLOB, PRIMARY KEY (spec_uri))";
    protected final DataSource dataSource;
    protected final String tableName;
    private final URI specStoreURI;
    protected final SpecSerDe specSerDe;
    protected final SqlStatements sqlStatements;

    public MysqlBaseSpecStore(Config config, SpecSerDe specSerDe) throws IOException {
        super(config, specSerDe);
        String configPrefix = this.getConfigPrefix();
        if (config.hasPath(configPrefix)) {
            config = config.getConfig(configPrefix).withFallback((ConfigMergeable)config);
        }
        this.dataSource = MysqlDataSourceFactory.get((Config)config, (SharedResourcesBroker)SharedResourcesBrokerFactory.getImplicitBroker());
        this.tableName = config.getString("state.store.db.table");
        this.specStoreURI = URI.create(config.getString("state.store.db.url"));
        this.specSerDe = specSerDe;
        this.sqlStatements = this.createSqlStatements();
        this.withPreparedStatement(this.sqlStatements.createTableStatement, statement -> statement.executeUpdate());
    }

    protected String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    protected SqlStatements createSqlStatements() {
        return new SqlStatements();
    }

    @Override
    public boolean existsImpl(URI specUri) throws IOException {
        return this.withPreparedStatement(this.sqlStatements.existsStatement, statement -> {
            statement.setString(1, specUri.toString());
            try (ResultSet rs = statement.executeQuery();){
                rs.next();
                Boolean bl = rs.getBoolean(1);
                return bl;
            }
        });
    }

    @Override
    public void addSpecImpl(Spec spec) throws IOException {
        this.addSpec(spec, DEFAULT_TAG_VALUE);
    }

    public void addSpec(Spec spec, String tagValue) throws IOException {
        this.withPreparedStatement(this.sqlStatements.insertStatement, statement -> {
            this.sqlStatements.completeInsertPreparedStatement((PreparedStatement)statement, spec, tagValue);
            statement.executeUpdate();
            return null;
        }, true);
    }

    @Override
    public boolean deleteSpec(Spec spec) throws IOException {
        return this.deleteSpec(spec.getUri());
    }

    @Override
    public boolean deleteSpecImpl(URI specUri) throws IOException {
        return this.withPreparedStatement(this.sqlStatements.deleteStatement, statement -> {
            statement.setString(1, specUri.toString());
            int result = statement.executeUpdate();
            return result != 0;
        }, true);
    }

    @Override
    public boolean deleteSpec(URI specUri, String version) throws IOException {
        return this.deleteSpec(specUri);
    }

    @Override
    public Spec updateSpecImpl(Spec spec) throws IOException {
        this.addSpec(spec);
        return spec;
    }

    @Override
    public Spec getSpecImpl(URI specUri) throws IOException, SpecNotFoundException {
        Iterator resultSpecs = this.withPreparedStatement(this.sqlStatements.getAllStatement + " WHERE spec_uri = ?", statement -> {
            statement.setString(1, specUri.toString());
            return this.retrieveSpecsWithModificationTime((PreparedStatement)statement).iterator();
        });
        if (resultSpecs.hasNext()) {
            return (Spec)resultSpecs.next();
        }
        throw new SpecNotFoundException(specUri);
    }

    @Override
    public Spec getSpec(URI specUri, String version) throws IOException, SpecNotFoundException {
        return this.getSpec(specUri);
    }

    @Override
    public Collection<Spec> getAllVersionsOfSpec(URI specUri) throws IOException, SpecNotFoundException {
        return Lists.newArrayList((Object[])new Spec[]{this.getSpec(specUri)});
    }

    @Override
    public Collection<Spec> getSpecsImpl() throws IOException {
        return this.withPreparedStatement(this.sqlStatements.getAllStatement, statement -> this.retrieveSpecs((PreparedStatement)statement));
    }

    protected final Collection<Spec> retrieveSpecs(PreparedStatement statement) throws IOException {
        ArrayList<Spec> specs = new ArrayList<Spec>();
        try (ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                specs.add(this.sqlStatements.extractSpec(rs));
            }
        }
        catch (SQLException | SpecSerDeException e) {
            log.error("Failed to deserialize spec", (Throwable)e);
            throw new IOException(e);
        }
        return specs;
    }

    protected final Collection<Spec> retrieveSpecsWithModificationTime(PreparedStatement statement) throws IOException {
        ArrayList<Spec> specs = new ArrayList<Spec>();
        try (ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                specs.add(this.sqlStatements.extractSpecWithModificationTime(rs));
            }
        }
        catch (SQLException | SpecSerDeException e) {
            log.error("Failed to deserialize spec", (Throwable)e);
            throw new IOException(e);
        }
        return specs;
    }

    @Override
    public Iterator<URI> getSpecURIsImpl() throws IOException {
        return this.withPreparedStatement(this.sqlStatements.getAllURIsStatement, statement -> this.retrieveURIs((PreparedStatement)statement).iterator());
    }

    @Override
    public int getSizeImpl() throws IOException {
        return this.withPreparedStatement(this.sqlStatements.getSizeStatement, statement -> {
            try (ResultSet resultSet = statement.executeQuery();){
                resultSet.next();
                Integer n = resultSet.getInt(1);
                return n;
            }
        });
    }

    @Override
    public Collection<Spec> getSpecsPaginatedImpl(int startOffset, int batchSize) throws IOException, IllegalArgumentException {
        if (startOffset < 0 || batchSize < 0) {
            throw new IllegalArgumentException(String.format("Received negative offset or batch size value when they should be >= 0. Offset is %s and batch size is %s", startOffset, batchSize));
        }
        return this.withPreparedStatement(this.sqlStatements.getBatchStatement, statement -> {
            this.sqlStatements.completeGetBatchStatement((PreparedStatement)statement, startOffset, batchSize);
            return this.retrieveSpecsWithModificationTime((PreparedStatement)statement);
        });
    }

    @Override
    public Iterator<URI> getSpecURIsWithTagImpl(String tag) throws IOException {
        return this.withPreparedStatement(this.sqlStatements.getAllURIsWithTagStatement, statement -> {
            statement.setString(1, tag);
            return this.retrieveURIs((PreparedStatement)statement).iterator();
        });
    }

    private List<URI> retrieveURIs(PreparedStatement statement) throws SQLException {
        ArrayList<URI> uris = new ArrayList<URI>();
        try (ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                URI specURI = URI.create(rs.getString(1));
                uris.add(specURI);
            }
        }
        return uris;
    }

    @Override
    public Optional<URI> getSpecStoreURI() {
        return Optional.of((Object)this.specStoreURI);
    }

    /*
     * Exception decompiling
     */
    protected <T> T withPreparedStatement(String sql, CheckedFunction<PreparedStatement, T> f, boolean shouldCommit) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final <T> T withPreparedStatement(String sql, CheckedFunction<PreparedStatement, T> f) throws IOException {
        return this.withPreparedStatement(sql, f, false);
    }

    protected class SqlStatements {
        public final String updateStatement;
        public final String existsStatement;
        public final String insertStatement;
        public final String deleteStatement;
        public final String getStatementBase;
        public final String getAllStatement;
        public final String getAllURIsStatement;
        public final String getAllURIsWithTagStatement;
        public final String getBatchStatement;
        public final String getSizeStatement;
        public final String createTableStatement;

        protected SqlStatements() {
            this.updateStatement = String.format(this.getTablelessUpdateStatement(), MysqlBaseSpecStore.this.tableName);
            this.existsStatement = String.format(this.getTablelessExistsStatement(), MysqlBaseSpecStore.this.tableName);
            this.insertStatement = String.format(this.getTablelessInsertStatement(), MysqlBaseSpecStore.this.tableName);
            this.deleteStatement = String.format(this.getTablelessDeleteStatement(), MysqlBaseSpecStore.this.tableName);
            this.getStatementBase = String.format(this.getTablelessGetStatementBase(), MysqlBaseSpecStore.this.tableName);
            this.getAllStatement = String.format(this.getTablelessGetAllStatement(), MysqlBaseSpecStore.this.tableName);
            this.getAllURIsStatement = String.format(this.getTablelessGetAllURIsStatement(), MysqlBaseSpecStore.this.tableName);
            this.getAllURIsWithTagStatement = String.format(this.getTablelessGetAllURIsWithTagStatement(), MysqlBaseSpecStore.this.tableName);
            this.getBatchStatement = String.format(this.getTablelessGetBatchStatement(), MysqlBaseSpecStore.this.tableName);
            this.getSizeStatement = String.format(this.getTablelessGetSizeStatement(), MysqlBaseSpecStore.this.tableName);
            this.createTableStatement = String.format(this.getTablelessCreateTableStatement(), MysqlBaseSpecStore.this.tableName);
        }

        public void completeInsertPreparedStatement(PreparedStatement statement, Spec spec, String tagValue) throws SQLException {
            URI specUri = spec.getUri();
            int i = 0;
            statement.setString(++i, specUri.toString());
            statement.setString(++i, tagValue);
            statement.setBlob(++i, new ByteArrayInputStream(MysqlBaseSpecStore.this.specSerDe.serialize(spec)));
        }

        public Spec extractSpec(ResultSet rs) throws SQLException, IOException {
            return MysqlBaseSpecStore.this.specSerDe.deserialize(ByteStreams.toByteArray((InputStream)rs.getBlob(2).getBinaryStream()));
        }

        public Spec extractSpecWithModificationTime(ResultSet rs) throws SQLException, IOException {
            Spec spec = MysqlBaseSpecStore.this.specSerDe.deserialize(ByteStreams.toByteArray((InputStream)rs.getBlob(2).getBinaryStream()));
            if (spec instanceof FlowSpec) {
                long timestamp = rs.getTimestamp("modified_time").getTime();
                FlowSpec flowSpec = (FlowSpec)spec;
                Properties properties = flowSpec.getConfigAsProperties();
                properties.setProperty("modified_time", String.valueOf(timestamp));
                return flowSpec;
            }
            return spec;
        }

        public void completeGetBatchStatement(PreparedStatement statement, int startOffset, int batchSize) throws SQLException {
            int i = 0;
            statement.setInt(++i, batchSize);
            statement.setInt(++i, startOffset);
        }

        protected String getTablelessExistsStatement() {
            return MysqlBaseSpecStore.EXISTS_STATEMENT;
        }

        protected String getTablelessUpdateStatement() {
            return MysqlBaseSpecStore.UPDATE_STATEMENT;
        }

        protected String getTablelessInsertStatement() {
            return MysqlBaseSpecStore.INSERT_STATEMENT;
        }

        protected String getTablelessDeleteStatement() {
            return MysqlBaseSpecStore.DELETE_STATEMENT;
        }

        protected String getTablelessGetStatementBase() {
            return MysqlBaseSpecStore.GET_STATEMENT_BASE;
        }

        protected String getTablelessGetAllStatement() {
            return MysqlBaseSpecStore.GET_ALL_STATEMENT;
        }

        protected String getTablelessGetAllURIsStatement() {
            return MysqlBaseSpecStore.GET_ALL_URIS_STATEMENT;
        }

        protected String getTablelessGetAllURIsWithTagStatement() {
            return MysqlBaseSpecStore.GET_ALL_URIS_WITH_TAG_STATEMENT;
        }

        protected String getTablelessGetBatchStatement() {
            return MysqlBaseSpecStore.GET_SPECS_BATCH_STATEMENT;
        }

        protected String getTablelessGetSizeStatement() {
            return MysqlBaseSpecStore.GET_SIZE_STATEMENT;
        }

        protected String getTablelessCreateTableStatement() {
            return CREATE_TABLE_STATEMENT;
        }
    }

    @FunctionalInterface
    protected static interface CheckedFunction<T, R> {
        public R apply(T var1) throws IOException, SQLException;
    }
}

