/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_serde;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.Properties;
import org.apache.gobblin.runtime.api.JobSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSpecDeserializer
implements JsonDeserializer<JobSpec> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSpecDeserializer.class);

    public JobSpec deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        Properties properties;
        JsonObject jsonObject = json.getAsJsonObject();
        String uri = jsonObject.get("uri").getAsString();
        String version = jsonObject.get("version").getAsString();
        String description = jsonObject.get("description").getAsString();
        Optional templateURI = Optional.ofNullable(jsonObject.get("templateURI")).flatMap(jsonElem -> {
            try {
                return Optional.of(new URI(jsonElem.getAsString()));
            }
            catch (RuntimeException | URISyntaxException e) {
                LOGGER.warn(String.format("error deserializing '%s' as a URI: %s", jsonElem.toString(), e.getMessage()));
                return Optional.empty();
            }
        });
        try {
            properties = (Properties)context.deserialize(jsonObject.get("configAsProperties"), Properties.class);
        }
        catch (JsonParseException e) {
            properties = new Properties();
            try {
                properties.load(new StringReader(jsonObject.get("configAsProperties").getAsString()));
            }
            catch (IOException ioe) {
                throw new JsonParseException((Throwable)e);
            }
        }
        JobSpec.Builder builder = JobSpec.builder(uri).withVersion(version).withDescription(description).withConfigAsProperties(properties);
        if (templateURI.isPresent()) {
            builder = builder.withTemplate((URI)templateURI.get());
        }
        return builder.build();
    }
}

