/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.services;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AbstractIdleService;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class JMXReportingService
extends AbstractIdleService {
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private Map<String, MetricSet> additionalMetricSets;
    private final JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();

    public JMXReportingService() {
        this((Map<String, MetricSet>)ImmutableMap.of());
    }

    public JMXReportingService(Map<String, MetricSet> additionalMetricSets) {
        this.additionalMetricSets = additionalMetricSets;
    }

    protected void startUp() throws Exception {
        this.registerJvmMetrics();
        this.jmxReporter.start();
    }

    protected void shutDown() throws Exception {
        this.jmxReporter.stop();
    }

    private void registerJvmMetrics() {
        this.registerMetricSetWithPrefix("jvm.gc", (MetricSet)new GarbageCollectorMetricSet());
        this.registerMetricSetWithPrefix("jvm.memory", (MetricSet)new MemoryUsageGaugeSet());
        this.registerMetricSetWithPrefix("jvm.threads", (MetricSet)new ThreadStatesGaugeSet());
        this.metricRegistry.register("jvm.fileDescriptorRatio", (Metric)new FileDescriptorRatioGauge());
        for (Map.Entry<String, MetricSet> metricSet : this.additionalMetricSets.entrySet()) {
            this.registerMetricSetWithPrefix(metricSet.getKey(), metricSet.getValue());
        }
    }

    private void registerMetricSetWithPrefix(String prefix, MetricSet metricSet) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{(String)entry.getKey()}), (Metric)entry.getValue());
        }
    }
}

