/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.messaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.gobblin.runtime.messaging.data.DynamicWorkUnitMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicWorkUnitConsumer
implements Consumer<List<DynamicWorkUnitMessage>> {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicWorkUnitConsumer.class);
    private final List<DynamicWorkUnitMessage.Handler> messageHandlers;

    public DynamicWorkUnitConsumer(Collection<DynamicWorkUnitMessage.Handler> handlers) {
        this.messageHandlers = new ArrayList<DynamicWorkUnitMessage.Handler>(handlers);
    }

    @Override
    public void accept(List<DynamicWorkUnitMessage> messages) {
        for (DynamicWorkUnitMessage msg : messages) {
            this.handleMessage(msg);
        }
    }

    private void handleMessage(DynamicWorkUnitMessage msg) {
        LOG.debug("{} handling message={}", (Object)DynamicWorkUnitConsumer.class.getSimpleName(), (Object)msg);
        for (DynamicWorkUnitMessage.Handler handler : this.messageHandlers) {
            handler.handle(msg);
        }
    }
}

