/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_catalog;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.Service;
import com.typesafe.config.Config;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.JobCatalog;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecNotFoundException;
import org.apache.gobblin.runtime.api.MutableJobCatalog;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.job_catalog.JobCatalogBase;
import org.apache.gobblin.runtime.spec_serde.GsonJobSpecSerDe;
import org.apache.gobblin.runtime.spec_store.MysqlBaseSpecStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlJobCatalog
extends JobCatalogBase
implements MutableJobCatalog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlJobCatalog.class);
    public static final String DB_CONFIG_PREFIX = "mysqlJobCatalog";
    protected final MutableJobCatalog.MutableStandardMetrics mutableMetrics;
    protected final MysqlBaseSpecStore jobSpecStore;

    public MysqlJobCatalog(Config sysConfig) throws IOException {
        this(sysConfig, (Optional<MetricContext>)Optional.absent(), GobblinMetrics.isEnabled((Config)sysConfig));
    }

    public MysqlJobCatalog(GobblinInstanceEnvironment env) throws IOException {
        super(env);
        this.mutableMetrics = (MutableJobCatalog.MutableStandardMetrics)this.metrics;
        this.jobSpecStore = this.createJobSpecStore(env.getSysConfig().getConfig());
    }

    public MysqlJobCatalog(Config sysConfig, Optional<MetricContext> parentMetricContext, boolean instrumentationEnabled) throws IOException {
        super((Optional<Logger>)Optional.of((Object)LOGGER), parentMetricContext, instrumentationEnabled, (Optional<Config>)Optional.of((Object)sysConfig));
        this.mutableMetrics = (MutableJobCatalog.MutableStandardMetrics)this.metrics;
        this.jobSpecStore = this.createJobSpecStore(sysConfig);
    }

    @Override
    protected JobCatalog.StandardMetrics createStandardMetrics(Optional<Config> sysConfig) {
        this.log.info("create standard metrics {} for {}", (Object)MutableJobCatalog.MutableStandardMetrics.class.getName(), (Object)this.getClass().getName());
        return new MutableJobCatalog.MutableStandardMetrics(this, sysConfig);
    }

    protected MysqlBaseSpecStore createJobSpecStore(Config sysConfig) {
        try {
            return new MysqlBaseSpecStore(sysConfig, new GsonJobSpecSerDe()){

                @Override
                protected String getConfigPrefix() {
                    return MysqlJobCatalog.DB_CONFIG_PREFIX;
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException("unable to create `JobSpec` store", e);
        }
    }

    public List<JobSpec> getJobs() {
        try {
            return (List)this.jobSpecStore.getSpecs();
        }
        catch (IOException e) {
            throw new RuntimeException("error getting (all) job specs", e);
        }
    }

    @Override
    public Iterator<JobSpec> getJobSpecIterator() {
        try {
            return Iterators.transform((Iterator)Iterators.filter((Iterator)Iterators.transform(this.jobSpecStore.getSpecURIs(), uri -> {
                try {
                    return Optional.of((Object)this.getJobSpec((URI)uri));
                }
                catch (JobSpecNotFoundException e) {
                    this.log.info("unable to retrieve previously identified JobSpec by URI '{}'", uri);
                    return Optional.absent();
                }
            }), Optional::isPresent), Optional::get);
        }
        catch (IOException e) {
            throw new RuntimeException("error iterating (all) job specs", e);
        }
    }

    @Override
    public JobSpec getJobSpec(URI uri) throws JobSpecNotFoundException {
        Preconditions.checkNotNull((Object)uri);
        try {
            return (JobSpec)this.jobSpecStore.getSpec(uri);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("error accessing job spec '%s'", uri), e);
        }
        catch (SpecNotFoundException e) {
            throw new JobSpecNotFoundException(uri);
        }
    }

    @Override
    public synchronized void put(JobSpec jobSpec) {
        block5: {
            Preconditions.checkState((this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)String.format("%s is not running.", this.getClass().getName()));
            Preconditions.checkNotNull((Object)jobSpec);
            try {
                long startTime = System.currentTimeMillis();
                boolean isUpdate = this.jobSpecStore.exists(jobSpec.getUri());
                if (isUpdate) {
                    try {
                        this.jobSpecStore.updateSpec(jobSpec);
                        this.mutableMetrics.updatePutJobTime(startTime);
                        this.listeners.onUpdateJob(jobSpec);
                        break block5;
                    }
                    catch (SpecNotFoundException e) {
                        throw new RuntimeException(String.format("error finding spec to update '%s'", jobSpec.getUri()), e);
                    }
                }
                this.jobSpecStore.addSpec(jobSpec);
                this.mutableMetrics.updatePutJobTime(startTime);
                this.listeners.onAddJob(jobSpec);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("error updating or adding JobSpec '%s'", jobSpec.getUri()), e);
            }
        }
    }

    @Override
    public synchronized void remove(URI jobURI) {
        this.remove(jobURI, false);
    }

    @Override
    public synchronized void remove(URI jobURI, boolean alwaysTriggerListeners) {
        Preconditions.checkState((this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)String.format("%s is not running.", this.getClass().getName()));
        Preconditions.checkNotNull((Object)jobURI);
        try {
            long startTime = System.currentTimeMillis();
            JobSpec jobSpec = (JobSpec)this.jobSpecStore.getSpec(jobURI);
            this.jobSpecStore.deleteSpec(jobURI);
            this.mutableMetrics.updateRemoveJobTime(startTime);
            this.listeners.onDeleteJob(jobURI, jobSpec.getVersion());
        }
        catch (SpecNotFoundException e) {
            LOGGER.warn("Unknown job spec URI: '" + jobURI + "'.  Deletion failed.");
        }
        catch (IOException e) {
            throw new RuntimeException("When removing a JobConf. file, issues unexpected happen:" + e.getMessage());
        }
        finally {
            if (alwaysTriggerListeners) {
                this.listeners.onCancelJob(jobURI);
            }
        }
    }
}

