/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.net.URI;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.gobblin.runtime.api.SpecSearchObject;
import org.apache.gobblin.service.FlowId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowSpecSearchObject
implements SpecSearchObject {
    private static final Logger log = LoggerFactory.getLogger(FlowSpecSearchObject.class);
    private final URI flowSpecUri;
    private final String flowGroup;
    private final String flowName;
    private final String templateURI;
    private final String userToProxy;
    private final String sourceIdentifier;
    private final String destinationIdentifier;
    private final String schedule;
    private final String modifiedTimestamp;
    private final Boolean isRunImmediately;
    private final String owningGroup;
    private final String propertyFilter;
    private final int start;
    private final int count;

    public static FlowSpecSearchObject fromFlowId(FlowId flowId) {
        return FlowSpecSearchObject.builder().flowGroup(flowId.getFlowGroup()).flowName(flowId.getFlowName()).build();
    }

    @Override
    public String augmentBaseGetStatement(String baseStatement) throws IOException {
        ArrayList<String> conditions = new ArrayList<String>();
        ArrayList<String> limitAndOffset = new ArrayList<String>();
        if (this.getFlowSpecUri() != null) {
            conditions.add("spec_uri = ?");
        }
        if (this.getFlowGroup() != null) {
            conditions.add("flow_group = ?");
        }
        if (this.getFlowName() != null) {
            conditions.add("flow_name = ?");
        }
        if (this.getTemplateURI() != null) {
            conditions.add("template_uri = ?");
        }
        if (this.getUserToProxy() != null) {
            conditions.add("user_to_proxy = ?");
        }
        if (this.getSourceIdentifier() != null) {
            conditions.add("source_identifier = ?");
        }
        if (this.getDestinationIdentifier() != null) {
            conditions.add("destination_identifier = ?");
        }
        if (this.getSchedule() != null) {
            conditions.add("schedule = ?");
        }
        if (this.getModifiedTimestamp() != null) {
            conditions.add("modified_time = ?");
        }
        if (this.getIsRunImmediately() != null) {
            conditions.add("isRunImmediately = ?");
        }
        if (this.getOwningGroup() != null) {
            conditions.add("owning_group = ?");
        }
        if (this.getCount() > 0) {
            limitAndOffset.add(" ORDER BY spec_uri ASC LIMIT ?");
            if (this.getStart() > 0) {
                limitAndOffset.add(" OFFSET ?");
            }
        }
        if (this.getPropertyFilter() != null) {
            String propertyFilter = this.getPropertyFilter();
            Splitter commaSplitter = Splitter.on((String)",").trimResults().omitEmptyStrings();
            for (String property : commaSplitter.splitToList((CharSequence)propertyFilter)) {
                if (property.contains("=")) {
                    String[] keyValue = property.split("=");
                    if (keyValue.length != 2) {
                        log.error("Incorrect flow config search query");
                        continue;
                    }
                    conditions.add("spec_json->'$.configAsProperties.\"" + keyValue[0] + "\"' like '%" + keyValue[1] + "%'");
                    continue;
                }
                conditions.add("spec_json->'$.configAsProperties.\"" + property + "\"' is not null");
            }
        }
        if (conditions.size() == 0 && limitAndOffset.size() == 0) {
            throw new IOException("At least one condition is required to query flow configs.");
        }
        return baseStatement + String.join((CharSequence)" AND ", conditions) + String.join((CharSequence)" ", limitAndOffset);
    }

    @Override
    public void completePreparedStatement(PreparedStatement statement) throws SQLException {
        int i = 0;
        if (this.getFlowSpecUri() != null) {
            statement.setString(++i, this.getFlowSpecUri().toString());
        }
        if (this.getFlowGroup() != null) {
            statement.setString(++i, this.getFlowGroup());
        }
        if (this.getFlowName() != null) {
            statement.setString(++i, this.getFlowName());
        }
        if (this.getTemplateURI() != null) {
            statement.setString(++i, this.getTemplateURI());
        }
        if (this.getUserToProxy() != null) {
            statement.setString(++i, this.getUserToProxy());
        }
        if (this.getSourceIdentifier() != null) {
            statement.setString(++i, this.getSourceIdentifier());
        }
        if (this.getDestinationIdentifier() != null) {
            statement.setString(++i, this.getDestinationIdentifier());
        }
        if (this.getSchedule() != null) {
            statement.setString(++i, this.getSchedule());
        }
        if (this.getIsRunImmediately() != null) {
            statement.setBoolean(++i, this.getIsRunImmediately());
        }
        if (this.getOwningGroup() != null) {
            statement.setString(++i, this.getOwningGroup());
        }
        if (this.getCount() > 0) {
            statement.setInt(++i, this.getCount());
            if (this.getStart() > 0) {
                statement.setInt(++i, this.getStart());
            }
        }
    }

    public static FlowSpecSearchObjectBuilder builder() {
        return new FlowSpecSearchObjectBuilder();
    }

    public URI getFlowSpecUri() {
        return this.flowSpecUri;
    }

    public String getFlowGroup() {
        return this.flowGroup;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getTemplateURI() {
        return this.templateURI;
    }

    public String getUserToProxy() {
        return this.userToProxy;
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public String getDestinationIdentifier() {
        return this.destinationIdentifier;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public String getModifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public Boolean getIsRunImmediately() {
        return this.isRunImmediately;
    }

    public String getOwningGroup() {
        return this.owningGroup;
    }

    public String getPropertyFilter() {
        return this.propertyFilter;
    }

    public int getStart() {
        return this.start;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return "FlowSpecSearchObject(flowSpecUri=" + this.getFlowSpecUri() + ", flowGroup=" + this.getFlowGroup() + ", flowName=" + this.getFlowName() + ", templateURI=" + this.getTemplateURI() + ", userToProxy=" + this.getUserToProxy() + ", sourceIdentifier=" + this.getSourceIdentifier() + ", destinationIdentifier=" + this.getDestinationIdentifier() + ", schedule=" + this.getSchedule() + ", modifiedTimestamp=" + this.getModifiedTimestamp() + ", isRunImmediately=" + this.getIsRunImmediately() + ", owningGroup=" + this.getOwningGroup() + ", propertyFilter=" + this.getPropertyFilter() + ", start=" + this.getStart() + ", count=" + this.getCount() + ")";
    }

    public FlowSpecSearchObject(URI flowSpecUri, String flowGroup, String flowName, String templateURI, String userToProxy, String sourceIdentifier, String destinationIdentifier, String schedule, String modifiedTimestamp, Boolean isRunImmediately, String owningGroup, String propertyFilter, int start, int count) {
        this.flowSpecUri = flowSpecUri;
        this.flowGroup = flowGroup;
        this.flowName = flowName;
        this.templateURI = templateURI;
        this.userToProxy = userToProxy;
        this.sourceIdentifier = sourceIdentifier;
        this.destinationIdentifier = destinationIdentifier;
        this.schedule = schedule;
        this.modifiedTimestamp = modifiedTimestamp;
        this.isRunImmediately = isRunImmediately;
        this.owningGroup = owningGroup;
        this.propertyFilter = propertyFilter;
        this.start = start;
        this.count = count;
    }

    public static class FlowSpecSearchObjectBuilder {
        private URI flowSpecUri;
        private String flowGroup;
        private String flowName;
        private String templateURI;
        private String userToProxy;
        private String sourceIdentifier;
        private String destinationIdentifier;
        private String schedule;
        private String modifiedTimestamp;
        private Boolean isRunImmediately;
        private String owningGroup;
        private String propertyFilter;
        private int start;
        private int count;

        FlowSpecSearchObjectBuilder() {
        }

        public FlowSpecSearchObjectBuilder flowSpecUri(URI flowSpecUri) {
            this.flowSpecUri = flowSpecUri;
            return this;
        }

        public FlowSpecSearchObjectBuilder flowGroup(String flowGroup) {
            this.flowGroup = flowGroup;
            return this;
        }

        public FlowSpecSearchObjectBuilder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public FlowSpecSearchObjectBuilder templateURI(String templateURI) {
            this.templateURI = templateURI;
            return this;
        }

        public FlowSpecSearchObjectBuilder userToProxy(String userToProxy) {
            this.userToProxy = userToProxy;
            return this;
        }

        public FlowSpecSearchObjectBuilder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public FlowSpecSearchObjectBuilder destinationIdentifier(String destinationIdentifier) {
            this.destinationIdentifier = destinationIdentifier;
            return this;
        }

        public FlowSpecSearchObjectBuilder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public FlowSpecSearchObjectBuilder modifiedTimestamp(String modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public FlowSpecSearchObjectBuilder isRunImmediately(Boolean isRunImmediately) {
            this.isRunImmediately = isRunImmediately;
            return this;
        }

        public FlowSpecSearchObjectBuilder owningGroup(String owningGroup) {
            this.owningGroup = owningGroup;
            return this;
        }

        public FlowSpecSearchObjectBuilder propertyFilter(String propertyFilter) {
            this.propertyFilter = propertyFilter;
            return this;
        }

        public FlowSpecSearchObjectBuilder start(int start) {
            this.start = start;
            return this;
        }

        public FlowSpecSearchObjectBuilder count(int count) {
            this.count = count;
            return this;
        }

        public FlowSpecSearchObject build() {
            return new FlowSpecSearchObject(this.flowSpecUri, this.flowGroup, this.flowName, this.templateURI, this.userToProxy, this.sourceIdentifier, this.destinationIdentifier, this.schedule, this.modifiedTimestamp, this.isRunImmediately, this.owningGroup, this.propertyFilter, this.start, this.count);
        }

        public String toString() {
            return "FlowSpecSearchObject.FlowSpecSearchObjectBuilder(flowSpecUri=" + this.flowSpecUri + ", flowGroup=" + this.flowGroup + ", flowName=" + this.flowName + ", templateURI=" + this.templateURI + ", userToProxy=" + this.userToProxy + ", sourceIdentifier=" + this.sourceIdentifier + ", destinationIdentifier=" + this.destinationIdentifier + ", schedule=" + this.schedule + ", modifiedTimestamp=" + this.modifiedTimestamp + ", isRunImmediately=" + this.isRunImmediately + ", owningGroup=" + this.owningGroup + ", propertyFilter=" + this.propertyFilter + ", start=" + this.start + ", count=" + this.count + ")";
        }
    }
}

