/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.metastore.MysqlStateStore;
import org.apache.gobblin.metastore.predicates.StateStorePredicate;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.metastore.mysql.MysqlDatasetStateStoreEntryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDatasetStateStore
extends MysqlStateStore<JobState.DatasetState>
implements DatasetStateStore<JobState.DatasetState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlDatasetStateStore.class);

    public MysqlDatasetStateStore(DataSource dataSource, String stateStoreTableName, boolean compressedValues) throws IOException {
        super(dataSource, stateStoreTableName, compressedValues, JobState.DatasetState.class);
    }

    public Map<String, JobState.DatasetState> getLatestDatasetStatesByUrns(String jobName) throws IOException {
        List previousDatasetStates = this.getAll(jobName, "%current.jst", MysqlStateStore.JobStateSearchColumns.TABLE_NAME_ONLY);
        HashMap datasetStatesByUrns = Maps.newHashMap();
        for (JobState.DatasetState previousDatasetState : previousDatasetStates) {
            datasetStatesByUrns.put(previousDatasetState.getDatasetUrn(), previousDatasetState);
        }
        if (datasetStatesByUrns.size() > 1) {
            datasetStatesByUrns.remove("");
        }
        return datasetStatesByUrns;
    }

    public JobState.DatasetState getLatestDatasetState(String storeName, String datasetUrn) throws IOException {
        String alias = Strings.isNullOrEmpty((String)datasetUrn) ? "current.jst" : CharMatcher.is((char)':').replaceFrom((CharSequence)datasetUrn, '.') + "-" + "current" + ".jst";
        return (JobState.DatasetState)this.get(storeName, alias, datasetUrn);
    }

    public void persistDatasetState(String datasetUrn, JobState.DatasetState datasetState) throws IOException {
        String jobName = datasetState.getJobName();
        String jobId = datasetState.getJobId();
        datasetUrn = CharMatcher.is((char)':').replaceFrom((CharSequence)datasetUrn, '.');
        String tableName = Strings.isNullOrEmpty((String)datasetUrn) ? jobId + ".jst" : datasetUrn + "-" + jobId + ".jst";
        LOGGER.info("Persisting " + tableName + " to the job state store");
        this.put(jobName, tableName, (State)datasetState);
        this.createAlias(jobName, tableName, MysqlDatasetStateStore.getAliasName(datasetUrn));
    }

    public void persistDatasetURNs(String storeName, Collection<String> datasetUrns) throws IOException {
    }

    private static String getAliasName(String datasetUrn) {
        return Strings.isNullOrEmpty((String)datasetUrn) ? "current.jst" : datasetUrn + "-" + "current" + ".jst";
    }

    public List<MysqlDatasetStateStoreEntryManager> getMetadataForTables(StateStorePredicate predicate) throws IOException {
        List entryManagers = super.getMetadataForTables(predicate);
        return entryManagers.stream().map(entry -> new MysqlDatasetStateStoreEntryManager(entry.getStoreName(), entry.getTableName(), entry.getTimestamp(), this)).collect(Collectors.toList());
    }
}

