/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import org.apache.gobblin.metrics.DatasetMetric;

public class DatasetTaskSummary {
    private final String datasetUrn;
    private final long recordsWritten;
    private final long bytesWritten;
    private final boolean successfullyCommitted;

    public static DatasetMetric toDatasetMetric(DatasetTaskSummary datasetTaskSummary) {
        return new DatasetMetric(datasetTaskSummary.getDatasetUrn(), Long.valueOf(datasetTaskSummary.getBytesWritten()), Long.valueOf(datasetTaskSummary.getRecordsWritten()), Boolean.valueOf(datasetTaskSummary.isSuccessfullyCommitted()));
    }

    public DatasetTaskSummary(String datasetUrn, long recordsWritten, long bytesWritten, boolean successfullyCommitted) {
        this.datasetUrn = datasetUrn;
        this.recordsWritten = recordsWritten;
        this.bytesWritten = bytesWritten;
        this.successfullyCommitted = successfullyCommitted;
    }

    public String getDatasetUrn() {
        return this.datasetUrn;
    }

    public long getRecordsWritten() {
        return this.recordsWritten;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public boolean isSuccessfullyCommitted() {
        return this.successfullyCommitted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatasetTaskSummary)) {
            return false;
        }
        DatasetTaskSummary other = (DatasetTaskSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRecordsWritten() != other.getRecordsWritten()) {
            return false;
        }
        if (this.getBytesWritten() != other.getBytesWritten()) {
            return false;
        }
        if (this.isSuccessfullyCommitted() != other.isSuccessfullyCommitted()) {
            return false;
        }
        String this$datasetUrn = this.getDatasetUrn();
        String other$datasetUrn = other.getDatasetUrn();
        return !(this$datasetUrn == null ? other$datasetUrn != null : !this$datasetUrn.equals(other$datasetUrn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatasetTaskSummary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $recordsWritten = this.getRecordsWritten();
        result = result * 59 + (int)($recordsWritten >>> 32 ^ $recordsWritten);
        long $bytesWritten = this.getBytesWritten();
        result = result * 59 + (int)($bytesWritten >>> 32 ^ $bytesWritten);
        result = result * 59 + (this.isSuccessfullyCommitted() ? 79 : 97);
        String $datasetUrn = this.getDatasetUrn();
        result = result * 59 + ($datasetUrn == null ? 43 : $datasetUrn.hashCode());
        return result;
    }

    public String toString() {
        return "DatasetTaskSummary(datasetUrn=" + this.getDatasetUrn() + ", recordsWritten=" + this.getRecordsWritten() + ", bytesWritten=" + this.getBytesWritten() + ", successfullyCommitted=" + this.isSuccessfullyCommitted() + ")";
    }
}

