/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.util;

import com.google.common.io.Closer;
import com.google.gson.stream.JsonWriter;
import com.typesafe.config.Config;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.JobConfigurationUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStateToJsonConverter {
    private static final Logger log = LoggerFactory.getLogger(JobStateToJsonConverter.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(JobStateToJsonConverter.class);
    private static final String JOB_STATE_STORE_TABLE_SUFFIX = ".jst";
    private final StateStore<? extends JobState> jobStateStore;
    private final boolean keepConfig;

    public JobStateToJsonConverter(StateStore stateStore, boolean keepConfig) {
        this.keepConfig = keepConfig;
        this.jobStateStore = stateStore;
    }

    public JobStateToJsonConverter(Properties props, String storeUrl, boolean keepConfig) throws IOException {
        Configuration conf = new Configuration();
        JobConfigurationUtils.putPropertiesIntoConfiguration((Properties)props, (Configuration)conf);
        if (StringUtils.isNotBlank((String)storeUrl)) {
            props.setProperty("state.store.dir", storeUrl);
        }
        this.jobStateStore = DatasetStateStore.buildDatasetStateStore((Config)ConfigUtils.propertiesToConfig((Properties)props));
        this.keepConfig = keepConfig;
    }

    public void convert(String jobName, String jobId, Writer writer) throws IOException {
        List jobStates = this.jobStateStore.getAll(jobName, jobId + JOB_STATE_STORE_TABLE_SUFFIX);
        if (jobStates.isEmpty()) {
            LOGGER.warn(String.format("No job state found for job with name %s and id %s", jobName, jobId));
            return;
        }
        try (JsonWriter jsonWriter = new JsonWriter(writer);){
            jsonWriter.setIndent("\t");
            this.writeJobState(jsonWriter, (JobState)jobStates.get(0));
        }
    }

    public void convert(String jobName, Writer writer) throws IOException {
        this.convert(jobName, "current", writer);
    }

    public void convertAll(String jobName, Writer writer) throws IOException {
        List jobStates = this.jobStateStore.getAll(jobName);
        if (jobStates.isEmpty()) {
            LOGGER.warn(String.format("No job state found for job with name %s", jobName));
            return;
        }
        try (JsonWriter jsonWriter = new JsonWriter(writer);){
            jsonWriter.setIndent("\t");
            this.writeJobStates(jsonWriter, jobStates);
        }
    }

    private void writeJobState(JsonWriter jsonWriter, JobState jobState) throws IOException {
        jobState.toJson(jsonWriter, this.keepConfig);
    }

    private void writeJobStates(JsonWriter jsonWriter, List<? extends JobState> jobStates) throws IOException {
        jsonWriter.beginArray();
        for (JobState jobState : jobStates) {
            this.writeJobState(jsonWriter, jobState);
        }
        jsonWriter.endArray();
    }

    public void outputToJson(CommandLine cmd) throws IOException {
        StringWriter stringWriter = new StringWriter();
        if (cmd.hasOption('i')) {
            this.convert(cmd.getOptionValue('n'), cmd.getOptionValue('i'), stringWriter);
        } else if (cmd.hasOption('a')) {
            this.convertAll(cmd.getOptionValue('n'), stringWriter);
        } else {
            this.convert(cmd.getOptionValue('n'), stringWriter);
        }
        if (cmd.hasOption('t')) {
            try (Closer closer = Closer.create();){
                FileOutputStream fileOutputStream = (FileOutputStream)closer.register((Closeable)new FileOutputStream(cmd.getOptionValue('t')));
                OutputStreamWriter outputStreamWriter = (OutputStreamWriter)closer.register((Closeable)new OutputStreamWriter((OutputStream)fileOutputStream, ConfigurationKeys.DEFAULT_CHARSET_ENCODING));
                BufferedWriter bufferedWriter = (BufferedWriter)closer.register((Closeable)new BufferedWriter(outputStreamWriter));
                bufferedWriter.write(stringWriter.toString());
            }
        } else {
            System.out.println(stringWriter.toString());
        }
    }
}

