/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.troubleshooter;

import java.time.ZonedDateTime;
import java.util.Map;
import org.apache.gobblin.runtime.troubleshooter.IssueSeverity;

public class Issue {
    private final ZonedDateTime time;
    private final IssueSeverity severity;
    private final String code;
    private final String summary;
    private final String details;
    private final String sourceClass;
    private final String exceptionClass;
    private final Map<String, String> properties;

    Issue(ZonedDateTime time, IssueSeverity severity, String code, String summary, String details, String sourceClass, String exceptionClass, Map<String, String> properties) {
        this.time = time;
        this.severity = severity;
        this.code = code;
        this.summary = summary;
        this.details = details;
        this.sourceClass = sourceClass;
        this.exceptionClass = exceptionClass;
        this.properties = properties;
    }

    public static IssueBuilder builder() {
        return new IssueBuilder();
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public String getCode() {
        return this.code;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDetails() {
        return this.details;
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public String getExceptionClass() {
        return this.exceptionClass;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Issue)) {
            return false;
        }
        Issue other = (Issue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ZonedDateTime this$time = this.getTime();
        ZonedDateTime other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        IssueSeverity this$severity = this.getSeverity();
        IssueSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        String this$details = this.getDetails();
        String other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
            return false;
        }
        String this$sourceClass = this.getSourceClass();
        String other$sourceClass = other.getSourceClass();
        if (this$sourceClass == null ? other$sourceClass != null : !this$sourceClass.equals(other$sourceClass)) {
            return false;
        }
        String this$exceptionClass = this.getExceptionClass();
        String other$exceptionClass = other.getExceptionClass();
        if (this$exceptionClass == null ? other$exceptionClass != null : !this$exceptionClass.equals(other$exceptionClass)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Issue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ZonedDateTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        IssueSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        String $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        String $sourceClass = this.getSourceClass();
        result = result * 59 + ($sourceClass == null ? 43 : $sourceClass.hashCode());
        String $exceptionClass = this.getExceptionClass();
        result = result * 59 + ($exceptionClass == null ? 43 : $exceptionClass.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public static class IssueBuilder {
        private ZonedDateTime time;
        private IssueSeverity severity;
        private String code;
        private String summary;
        private String details;
        private String sourceClass;
        private String exceptionClass;
        private Map<String, String> properties;

        IssueBuilder() {
        }

        public IssueBuilder time(ZonedDateTime time) {
            this.time = time;
            return this;
        }

        public IssueBuilder severity(IssueSeverity severity) {
            this.severity = severity;
            return this;
        }

        public IssueBuilder code(String code) {
            this.code = code;
            return this;
        }

        public IssueBuilder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public IssueBuilder details(String details) {
            this.details = details;
            return this;
        }

        public IssueBuilder sourceClass(String sourceClass) {
            this.sourceClass = sourceClass;
            return this;
        }

        public IssueBuilder exceptionClass(String exceptionClass) {
            this.exceptionClass = exceptionClass;
            return this;
        }

        public IssueBuilder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Issue build() {
            return new Issue(this.time, this.severity, this.code, this.summary, this.details, this.sourceClass, this.exceptionClass, this.properties);
        }

        public String toString() {
            return "Issue.IssueBuilder(time=" + this.time + ", severity=" + (Object)((Object)this.severity) + ", code=" + this.code + ", summary=" + this.summary + ", details=" + this.details + ", sourceClass=" + this.sourceClass + ", exceptionClass=" + this.exceptionClass + ", properties=" + this.properties + ")";
        }
    }
}

