/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.troubleshooter;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.runtime.troubleshooter.Issue;
import org.apache.gobblin.runtime.troubleshooter.IssueRefinery;
import org.apache.gobblin.runtime.troubleshooter.IssueSeverity;

public class DefaultIssueRefinery
implements IssueRefinery {
    @Override
    public List<Issue> refine(ImmutableList<Issue> sourceIssues) {
        LinkedList<Issue> issues = new LinkedList<Issue>((Collection<Issue>)sourceIssues);
        issues.sort(Comparator.comparing(Issue::getSeverity).reversed().thenComparing(Issue::getTime));
        issues.removeIf(i -> i.getSeverity().isEqualOrLowerThan(IssueSeverity.WARN) && StringUtils.containsIgnoreCase((String)i.getSourceClass(), (String)"com.linkedin.kafka"));
        issues.removeIf(i -> i.getSeverity().isEqualOrLowerThan(IssueSeverity.WARN) && StringUtils.containsIgnoreCase((String)i.getSourceClass(), (String)"org.apache.kafka"));
        this.moveToBottom(issues, i -> StringUtils.containsIgnoreCase((String)i.getSourceClass(), (String)"org.apache.gobblin.metrics"));
        return issues;
    }

    private void moveToBottom(LinkedList<Issue> issues, Predicate<Issue> predicate) {
        Collection movedIssues = issues.stream().filter(predicate).collect(Collectors.toList());
        issues.removeAll(movedIssues);
        issues.addAll(movedIssues);
    }
}

