/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.task;

import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.TaskContext;
import org.apache.gobblin.runtime.task.TaskIFace;
import org.apache.gobblin.runtime.util.TaskMetrics;

public abstract class BaseAbstractTask
implements TaskIFace {
    protected WorkUnitState.WorkingState workingState = WorkUnitState.WorkingState.PENDING;
    protected MetricContext metricContext;

    public BaseAbstractTask(TaskContext taskContext) {
        this.metricContext = TaskMetrics.get(taskContext.getTaskState()).getMetricContext();
    }

    @Override
    public void run() {
        this.workingState = WorkUnitState.WorkingState.SUCCESSFUL;
    }

    @Override
    public void commit() {
        this.workingState = WorkUnitState.WorkingState.SUCCESSFUL;
    }

    @Override
    public State getPersistentState() {
        return new State();
    }

    @Override
    public State getExecutionMetadata() {
        return new State();
    }

    @Override
    public WorkUnitState.WorkingState getWorkingState() {
        return this.workingState;
    }

    @Override
    public void shutdown() {
        if (this.getWorkingState() == WorkUnitState.WorkingState.PENDING || this.getWorkingState() == WorkUnitState.WorkingState.RUNNING) {
            this.workingState = WorkUnitState.WorkingState.CANCELLED;
        }
    }

    @Override
    public boolean awaitShutdown(long timeoutMillis) {
        return true;
    }

    @Override
    public String getProgress() {
        return this.getWorkingState().toString();
    }

    @Override
    public boolean isSpeculativeExecutionSafe() {
        return false;
    }
}

