/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.std;

import java.net.URI;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.api.JobExecution;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.util.JobLauncherUtils;

@Alpha
public class JobExecutionUpdatable
implements JobExecution {
    protected final URI jobSpecURI;
    protected final String jobSpecVersion;
    protected final long launchTimeMillis;
    protected final String executionId;

    public static JobExecutionUpdatable createFromJobSpec(JobSpec jobSpec) {
        return new JobExecutionUpdatable(jobSpec.getUri(), jobSpec.getVersion(), System.currentTimeMillis(), JobLauncherUtils.newJobId((String)JobState.getJobNameFromProps(jobSpec.getConfigAsProperties())));
    }

    @Override
    public URI getJobSpecURI() {
        return this.jobSpecURI;
    }

    @Override
    public String getJobSpecVersion() {
        return this.jobSpecVersion;
    }

    @Override
    public long getLaunchTimeMillis() {
        return this.launchTimeMillis;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobExecutionUpdatable)) {
            return false;
        }
        JobExecutionUpdatable other = (JobExecutionUpdatable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLaunchTimeMillis() != other.getLaunchTimeMillis()) {
            return false;
        }
        URI this$jobSpecURI = this.getJobSpecURI();
        URI other$jobSpecURI = other.getJobSpecURI();
        if (this$jobSpecURI == null ? other$jobSpecURI != null : !((Object)this$jobSpecURI).equals(other$jobSpecURI)) {
            return false;
        }
        String this$jobSpecVersion = this.getJobSpecVersion();
        String other$jobSpecVersion = other.getJobSpecVersion();
        if (this$jobSpecVersion == null ? other$jobSpecVersion != null : !this$jobSpecVersion.equals(other$jobSpecVersion)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        return !(this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobExecutionUpdatable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $launchTimeMillis = this.getLaunchTimeMillis();
        result = result * 59 + (int)($launchTimeMillis >>> 32 ^ $launchTimeMillis);
        URI $jobSpecURI = this.getJobSpecURI();
        result = result * 59 + ($jobSpecURI == null ? 43 : ((Object)$jobSpecURI).hashCode());
        String $jobSpecVersion = this.getJobSpecVersion();
        result = result * 59 + ($jobSpecVersion == null ? 43 : $jobSpecVersion.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        return result;
    }

    public String toString() {
        return "JobExecutionUpdatable(jobSpecURI=" + this.getJobSpecURI() + ", jobSpecVersion=" + this.getJobSpecVersion() + ", launchTimeMillis=" + this.getLaunchTimeMillis() + ", executionId=" + this.getExecutionId() + ")";
    }

    public JobExecutionUpdatable(URI jobSpecURI, String jobSpecVersion, long launchTimeMillis, String executionId) {
        this.jobSpecURI = jobSpecURI;
        this.jobSpecVersion = jobSpecVersion;
        this.launchTimeMillis = launchTimeMillis;
        this.executionId = executionId;
    }
}

