/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_serde;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class GsonSerDe<T> {
    private final Gson gson;
    private final JsonSerializer<T> serializer;
    private final JsonDeserializer<T> deserializer;
    private final Type type;

    public GsonSerDe(Type type, JsonSerializer<T> serializer, JsonDeserializer<T> deserializer) {
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.type = type;
        this.gson = new GsonBuilder().registerTypeAdapter(type, serializer).registerTypeAdapter(type, deserializer).create();
    }

    public String serialize(T object) {
        return this.gson.toJson(object, this.type);
    }

    public T deserialize(String serializedObject) {
        return (T)this.gson.fromJson(serializedObject, this.type);
    }
}

