/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_serde;

import com.google.common.base.Charsets;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecSerDe;
import org.apache.gobblin.runtime.api.SpecSerDeException;
import org.apache.gobblin.runtime.spec_serde.FlowSpecDeserializer;
import org.apache.gobblin.runtime.spec_serde.FlowSpecSerializer;
import org.apache.gobblin.runtime.spec_serde.GsonSerDe;

public class GsonFlowSpecSerDe
implements SpecSerDe {
    private GsonSerDe<FlowSpec> gsonSerDe = new GsonSerDe<FlowSpec>(new TypeToken<FlowSpec>(){}.getType(), new FlowSpecSerializer(), new FlowSpecDeserializer());

    @Override
    public byte[] serialize(Spec spec) throws SpecSerDeException {
        if (!(spec instanceof FlowSpec)) {
            throw new SpecSerDeException("Failed to serialize spec " + spec.getUri() + ", only FlowSpec is supported");
        }
        try {
            return this.gsonSerDe.serialize((FlowSpec)spec).getBytes(Charsets.UTF_8);
        }
        catch (JsonParseException e) {
            throw new SpecSerDeException(spec, (Throwable)e);
        }
    }

    @Override
    public Spec deserialize(byte[] spec) throws SpecSerDeException {
        try {
            return this.gsonSerDe.deserialize(new String(spec, Charsets.UTF_8));
        }
        catch (JsonParseException e) {
            throw new SpecSerDeException(e);
        }
    }
}

