/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_serde;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.Spec;

public class FlowSpecDeserializer
implements JsonDeserializer<FlowSpec> {
    public FlowSpec deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        Properties properties;
        JsonObject jsonObject = json.getAsJsonObject();
        String uri = jsonObject.get("uri").getAsString();
        String version = jsonObject.get("version").getAsString();
        String description = jsonObject.get("description").getAsString();
        Config config = ConfigFactory.parseString((String)jsonObject.get("config").getAsString());
        try {
            properties = (Properties)context.deserialize(jsonObject.get("configAsProperties"), Properties.class);
        }
        catch (JsonParseException e) {
            properties = new Properties();
            try {
                properties.load(new StringReader(jsonObject.get("configAsProperties").getAsString()));
            }
            catch (IOException ioe) {
                throw new JsonParseException((Throwable)e);
            }
        }
        HashSet<URI> templateURIs = new HashSet<URI>();
        try {
            for (Object template : jsonObject.get("templateURIs").getAsJsonArray()) {
                templateURIs.add(new URI(template.getAsString()));
            }
        }
        catch (URISyntaxException e) {
            throw new JsonParseException((Throwable)e);
        }
        ArrayList<Spec> childSpecs = new ArrayList<Spec>();
        for (JsonElement spec : jsonObject.get("childSpecs").getAsJsonArray()) {
            childSpecs.add((Spec)context.deserialize(spec, FlowSpec.class));
        }
        FlowSpec.Builder builder = FlowSpec.builder(uri).withVersion(version).withDescription(description).withConfig(config).withConfigAsProperties(properties);
        if (!templateURIs.isEmpty()) {
            builder = builder.withTemplates(templateURIs);
        }
        if (!childSpecs.isEmpty()) {
            builder = builder.withChildSpecs(childSpecs);
        }
        return builder.build();
    }
}

