/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_executorInstance;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.api.SpecProducer;
import org.apache.gobblin.runtime.spec_executorInstance.AbstractSpecExecutor;
import org.apache.gobblin.runtime.spec_executorInstance.InMemorySpecProducer;
import org.apache.gobblin.util.CompletedFuture;
import org.slf4j.Logger;

public class InMemorySpecExecutor
extends AbstractSpecExecutor {
    private SpecProducer<Spec> inMemorySpecProducer;

    public InMemorySpecExecutor(Config config) {
        this(config, (Optional<Logger>)Optional.absent());
    }

    public InMemorySpecExecutor(Config config, GobblinInstanceEnvironment env) {
        this(config, (Optional<Logger>)Optional.of((Object)env.getLog()));
    }

    public InMemorySpecExecutor(Config config, Optional<Logger> log) {
        super(config, log);
        this.inMemorySpecProducer = new InMemorySpecProducer(config);
    }

    public static SpecExecutor createDummySpecExecutor(URI uri) {
        Properties properties = new Properties();
        properties.setProperty("specExecInstance.uri", uri.toString());
        return new InMemorySpecExecutor(ConfigFactory.parseProperties((Properties)properties));
    }

    @Override
    public Future<String> getDescription() {
        return new CompletedFuture((Object)"InMemory SpecExecutor", null);
    }

    @Override
    public Future<? extends SpecProducer<Spec>> getProducer() {
        return new CompletedFuture(this.inMemorySpecProducer, null);
    }

    @Override
    protected void startUp() throws Exception {
    }

    @Override
    protected void shutDown() throws Exception {
    }
}

