/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.services;

import com.google.common.util.concurrent.AbstractIdleService;
import java.util.Properties;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MultiReporterException;
import org.apache.gobblin.metrics.reporter.util.MetricReportUtils;
import org.apache.gobblin.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsReportingService
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(MetricsReportingService.class);
    public static final String METRICS_REPORTING_FAILURE_FATAL_KEY = "metrics.reporting.failure.fatal";
    public static final String EVENT_REPORTING_FAILURE_FATAL_KEY = "event.reporting.failure.fatal";
    public static final String DEFAULT_METRICS_REPORTING_FAILURE_FATAL = "false";
    public static final String DEFAULT_EVENT_REPORTING_FAILURE_FATAL = "false";
    private final Properties properties;
    private final String appId;
    private final boolean isMetricReportingFailureFatal;
    private final boolean isEventReportingFailureFatal;

    public MetricsReportingService(Properties properties, String appId) {
        this.properties = properties;
        this.appId = appId;
        this.isMetricReportingFailureFatal = PropertiesUtils.getPropAsBoolean((Properties)properties, (String)METRICS_REPORTING_FAILURE_FATAL_KEY, (String)"false");
        this.isEventReportingFailureFatal = PropertiesUtils.getPropAsBoolean((Properties)properties, (String)EVENT_REPORTING_FAILURE_FATAL_KEY, (String)"false");
    }

    protected void startUp() throws Exception {
        block2: {
            try {
                GobblinMetrics.get((String)this.appId).startMetricReporting(this.properties);
            }
            catch (MultiReporterException ex) {
                if (!MetricReportUtils.shouldThrowException((Logger)log, (MultiReporterException)ex, (boolean)this.isMetricReportingFailureFatal, (boolean)this.isEventReportingFailureFatal)) break block2;
                throw ex;
            }
        }
    }

    protected void shutDown() throws Exception {
        GobblinMetrics.get((String)this.appId).stopMetricsReporting();
    }
}

