/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.instance.hadoop;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class HadoopConfigLoader {
    public static final String HADOOP_CONF_OVERRIDES_ROOT = "hadoop-inject";
    public static final String STRIP_SUFFIX = ".ROOT";
    private final Configuration _conf = new Configuration();

    public HadoopConfigLoader() {
        this(ConfigFactory.load());
    }

    public HadoopConfigLoader(Config rootConfig) {
        if (rootConfig.hasPath(HADOOP_CONF_OVERRIDES_ROOT)) {
            HadoopConfigLoader.addOverrides(this._conf, rootConfig.getConfig(HADOOP_CONF_OVERRIDES_ROOT));
        }
    }

    public Configuration getConf() {
        return new Configuration(this._conf);
    }

    static void addOverrides(Configuration conf, Config config) {
        for (Map.Entry entry : config.entrySet()) {
            String propName = (String)entry.getKey();
            if (propName.endsWith(STRIP_SUFFIX)) {
                propName = propName.substring(0, propName.length() - STRIP_SUFFIX.length());
            }
            conf.set(propName, ((ConfigValue)entry.getValue()).unwrapped().toString());
        }
    }
}

