/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.cli;

import com.typesafe.config.Config;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.metastore.FsStateStoreFactory;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.cli.CliApplication;
import org.apache.gobblin.runtime.util.JobStateToJsonConverter;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.JobConfigurationUtils;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="job-state-store", description="View or delete JobState in state store")
public class JobStateStoreCLI
implements CliApplication {
    private static final Logger log = LoggerFactory.getLogger(JobStateStoreCLI.class);
    Option sysConfigOption = Option.builder((String)"sc").argName("system configuration file").desc("Gobblin system configuration file (required if no state store URL specified)").longOpt("sysconfig").hasArg().build();
    Option storeUrlOption = Option.builder((String)"u").argName("gobblin state store URL").desc("Gobblin state store root path URL (required if no sysconfig specified)").longOpt("storeurl").hasArg().build();
    Option jobNameOption = Option.builder((String)"n").argName("gobblin job name").desc("Gobblin job name").longOpt("name").hasArg().build();
    Option jobIdOption = Option.builder((String)"i").argName("gobblin job id").desc("Gobblin job id").longOpt("id").hasArg().build();
    Option helpOption = Option.builder((String)"h").argName("help").desc("Usage").longOpt("help").hasArg().build();
    Option deleteOption = Option.builder((String)"d").argName("delete state").desc("Deletes a state from the state store with a job id").longOpt("delete").build();
    Option bulkDeleteOption = Option.builder((String)"bd").argName("bulk delete").desc("Deletes states from the state store based on a file with job ids to delete, separated by newline").longOpt("bulkDelete").hasArg().build();
    Option getAsJsonOption = Option.builder((String)"r").argName("read job state").desc("Converts a job state to json").longOpt("read-job-state").build();
    Option convertAllOption = Option.builder((String)"a").desc("Whether to convert all past job states of the given job when viewing as json").longOpt("all").build();
    Option keepConfigOption = Option.builder((String)"kc").desc("Whether to keep all configuration properties when viewing as json").longOpt("keepConfig").build();
    Option outputToFile = Option.builder((String)"t").argName("output file name").desc("Output file name when viewing as json").longOpt("toFile").hasArg().build();
    private static final Logger LOGGER = LoggerFactory.getLogger(JobStateStoreCLI.class);
    private StateStore<? extends JobState> jobStateStore;

    CommandLine initializeOptions(String[] args) {
        HelpFormatter formatter;
        Options options = new Options();
        options.addOption(this.sysConfigOption);
        options.addOption(this.storeUrlOption);
        options.addOption(this.jobNameOption);
        options.addOption(this.jobIdOption);
        options.addOption(this.deleteOption);
        options.addOption(this.getAsJsonOption);
        options.addOption(this.convertAllOption);
        options.addOption(this.keepConfigOption);
        options.addOption(this.outputToFile);
        options.addOption(this.bulkDeleteOption);
        CommandLine cmd = null;
        try {
            DefaultParser parser = new DefaultParser();
            cmd = parser.parse(options, Arrays.copyOfRange(args, 1, args.length));
        }
        catch (ParseException pe) {
            HelpFormatter formatter2 = new HelpFormatter();
            formatter2.printHelp("JobStateStoreCLI", options);
            throw new RuntimeException(pe);
        }
        if (!cmd.hasOption(this.sysConfigOption.getLongOpt()) && !cmd.hasOption(this.storeUrlOption.getLongOpt())) {
            System.out.println("State store configuration or state store url options missing");
            formatter = new HelpFormatter();
            formatter.printHelp("JobStateStoreCLI", options);
            return null;
        }
        if (cmd.hasOption(this.getAsJsonOption.getOpt()) && !cmd.hasOption(this.jobNameOption.getOpt())) {
            System.out.println("Job name option missing for reading job states as json");
            formatter = new HelpFormatter();
            formatter.printHelp("JobStateStoreCLI", options);
            return null;
        }
        if (cmd.hasOption(this.deleteOption.getOpt()) && !cmd.hasOption(this.jobNameOption.getOpt())) {
            System.out.println("Job name option missing for delete job id");
            formatter = new HelpFormatter();
            formatter.printHelp("JobStateStoreCLI", options);
            return null;
        }
        if (cmd.hasOption(this.helpOption.getOpt())) {
            formatter = new HelpFormatter();
            formatter.printHelp("JobStateStoreCLI", options);
            return null;
        }
        return cmd;
    }

    public void run(String[] args) throws Exception {
        StateStore.Factory stateStoreFactory;
        String storeUrl;
        CommandLine cmd = this.initializeOptions(args);
        if (cmd == null) {
            return;
        }
        Properties props = new Properties();
        if (cmd.hasOption(this.sysConfigOption.getOpt())) {
            props = JobConfigurationUtils.fileToProperties((String)cmd.getOptionValue(this.sysConfigOption.getOpt()));
        }
        if (StringUtils.isNotBlank((String)(storeUrl = cmd.getOptionValue(this.storeUrlOption.getLongOpt())))) {
            props.setProperty("state.store.dir", storeUrl);
        }
        Config stateStoreConfig = ConfigUtils.propertiesToConfig((Properties)props);
        ClassAliasResolver resolver = new ClassAliasResolver(StateStore.Factory.class);
        try {
            stateStoreFactory = (StateStore.Factory)resolver.resolveClass(ConfigUtils.getString((Config)stateStoreConfig, (String)"state.store.type", (String)FsStateStoreFactory.class.getName())).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.jobStateStore = stateStoreFactory.createStateStore(stateStoreConfig, JobState.class);
        if (cmd.hasOption(this.getAsJsonOption.getOpt())) {
            this.viewStateAsJson(cmd);
        } else if (cmd.hasOption(this.bulkDeleteOption.getOpt())) {
            this.deleteJobBulk(cmd.getOptionValue(this.bulkDeleteOption.getOpt()));
        } else if (cmd.hasOption(this.deleteOption.getOpt())) {
            this.deleteJob(cmd.getOptionValue(this.jobNameOption.getOpt()));
        }
    }

    private void deleteJobBulk(String path) throws IOException {
        Path filePath = new Path(path);
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath.toString()), Charset.forName("UTF-8")));){
            String jobName;
            while ((jobName = br.readLine()) != null) {
                System.out.println("Deleting " + jobName);
                try {
                    this.jobStateStore.delete(jobName);
                }
                catch (IOException e) {
                    System.out.println("Could not delete job name: " + jobName + " due to " + e.getMessage());
                }
            }
        }
    }

    private void deleteJob(String jobName) {
        System.out.println("Deleting " + jobName);
        try {
            this.jobStateStore.delete(jobName);
        }
        catch (IOException e) {
            System.out.println("Could not delete job name: " + jobName + " due to " + e.getMessage());
        }
    }

    private void viewStateAsJson(CommandLine cmd) throws IOException {
        JobStateToJsonConverter converter = new JobStateToJsonConverter(this.jobStateStore, cmd.hasOption("kc"));
        converter.outputToJson(cmd);
    }
}

