/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.slf4j.Logger;

public interface SecureJobTemplate
extends JobTemplate {
    public static Config filterUserConfig(SecureJobTemplate template, Config userConfig, Logger logger) {
        if (!template.isSecure()) {
            return userConfig;
        }
        Config survivingConfig = ConfigFactory.empty();
        for (String key : template.overridableProperties()) {
            if (!userConfig.hasPath(key)) continue;
            survivingConfig = survivingConfig.withValue(key, userConfig.getValue(key));
            userConfig = userConfig.withoutPath(key);
        }
        if (!userConfig.isEmpty()) {
            logger.warn(String.format("Secure template %s ignored the following keys because they are not overridable: %s", template.getUri().toString(), userConfig.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.joining(", "))));
        }
        return survivingConfig;
    }

    public boolean isSecure();

    public Collection<String> overridableProperties();
}

