/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.api.SpecSearchObject;
import org.apache.gobblin.runtime.api.SpecSerDe;
import org.apache.gobblin.runtime.api.SpecStore;
import org.apache.gobblin.util.ConfigUtils;

public abstract class InstrumentedSpecStore
implements SpecStore {
    private Optional<Timer> getTimer;
    private Optional<Timer> existsTimer;
    private Optional<Timer> deleteTimer;
    private Optional<Timer> addTimer;
    private Optional<Timer> updateTimer;
    private Optional<Timer> getAllTimer;
    private Optional<Timer> getURIsTimer;
    private MetricContext metricContext;
    private final boolean instrumentationEnabled;

    public InstrumentedSpecStore(Config config, SpecSerDe specSerDe) {
        this.instrumentationEnabled = GobblinMetrics.isEnabled((State)new State(ConfigUtils.configToProperties((Config)config)));
        this.metricContext = Instrumented.getMetricContext((State)new State(), this.getClass());
        this.getTimer = this.createTimer("-GET");
        this.existsTimer = this.createTimer("-EXISTS");
        this.deleteTimer = this.createTimer("-DELETE");
        this.addTimer = this.createTimer("-ADD");
        this.updateTimer = this.createTimer("-UPDATE");
        this.getAllTimer = this.createTimer("-GETALL");
        this.getURIsTimer = this.createTimer("-GETURIS");
    }

    private Optional<Timer> createTimer(String suffix) {
        return this.instrumentationEnabled ? Optional.of((Object)this.metricContext.timer(MetricRegistry.name((String)"GobblinService", (String[])new String[]{this.getClass().getSimpleName(), suffix}))) : Optional.absent();
    }

    @Override
    public boolean exists(URI specUri) throws IOException {
        if (!this.instrumentationEnabled) {
            return this.existsImpl(specUri);
        }
        long startTimeMillis = System.currentTimeMillis();
        boolean ret = this.existsImpl(specUri);
        Instrumented.updateTimer(this.existsTimer, (long)(System.currentTimeMillis() - startTimeMillis), (TimeUnit)TimeUnit.MILLISECONDS);
        return ret;
    }

    @Override
    public void addSpec(Spec spec) throws IOException {
        if (!this.instrumentationEnabled) {
            this.addSpecImpl(spec);
        } else {
            long startTimeMillis = System.currentTimeMillis();
            this.addSpecImpl(spec);
            Instrumented.updateTimer(this.addTimer, (long)(System.currentTimeMillis() - startTimeMillis), (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public boolean deleteSpec(URI specUri) throws IOException {
        if (!this.instrumentationEnabled) {
            return this.deleteSpecImpl(specUri);
        }
        long startTimeMillis = System.currentTimeMillis();
        boolean ret = this.deleteSpecImpl(specUri);
        Instrumented.updateTimer(this.deleteTimer, (long)(System.currentTimeMillis() - startTimeMillis), (TimeUnit)TimeUnit.MILLISECONDS);
        return ret;
    }

    @Override
    public Spec getSpec(URI specUri) throws IOException, SpecNotFoundException {
        if (!this.instrumentationEnabled) {
            return this.getSpecImpl(specUri);
        }
        long startTimeMillis = System.currentTimeMillis();
        Spec spec = this.getSpecImpl(specUri);
        Instrumented.updateTimer(this.getTimer, (long)(System.currentTimeMillis() - startTimeMillis), (TimeUnit)TimeUnit.MILLISECONDS);
        return spec;
    }

    @Override
    public Collection<Spec> getSpecs(SpecSearchObject specSearchObject) throws IOException {
        if (!this.instrumentationEnabled) {
            return this.getSpecsImpl(specSearchObject);
        }
        long startTimeMillis = System.currentTimeMillis();
        Collection<Spec> specs = this.getSpecsImpl(specSearchObject);
        Instrumented.updateTimer(this.getTimer, (long)(System.currentTimeMillis() - startTimeMillis), (TimeUnit)TimeUnit.MILLISECONDS);
        return specs;
    }

    @Override
    public Spec updateSpec(Spec spec) throws IOException, SpecNotFoundException {
        if (!this.instrumentationEnabled) {
            return this.updateSpecImpl(spec);
        }
        long startTimeMillis = System.currentTimeMillis();
        Spec ret = this.updateSpecImpl(spec);
        Instrumented.updateTimer(this.updateTimer, (long)(System.currentTimeMillis() - startTimeMillis), (TimeUnit)TimeUnit.MILLISECONDS);
        return ret;
    }

    @Override
    public Collection<Spec> getSpecs() throws IOException {
        if (!this.instrumentationEnabled) {
            return this.getSpecsImpl();
        }
        long startTimeMillis = System.currentTimeMillis();
        Collection<Spec> spec = this.getSpecsImpl();
        Instrumented.updateTimer(this.getAllTimer, (long)(System.currentTimeMillis() - startTimeMillis), (TimeUnit)TimeUnit.MILLISECONDS);
        return spec;
    }

    @Override
    public Iterator<URI> getSpecURIs() throws IOException {
        if (!this.instrumentationEnabled) {
            return this.getSpecURIsImpl();
        }
        long startTimeMillis = System.currentTimeMillis();
        Iterator<URI> specURIs = this.getSpecURIsImpl();
        Instrumented.updateTimer(this.getURIsTimer, (long)(System.currentTimeMillis() - startTimeMillis), (TimeUnit)TimeUnit.MILLISECONDS);
        return specURIs;
    }

    public abstract void addSpecImpl(Spec var1) throws IOException;

    public abstract Spec updateSpecImpl(Spec var1) throws IOException, SpecNotFoundException;

    public abstract boolean existsImpl(URI var1) throws IOException;

    public abstract Spec getSpecImpl(URI var1) throws IOException, SpecNotFoundException;

    public abstract boolean deleteSpecImpl(URI var1) throws IOException;

    public abstract Collection<Spec> getSpecsImpl() throws IOException;

    public abstract Iterator<URI> getSpecURIsImpl() throws IOException;

    public Collection<Spec> getSpecsImpl(SpecSearchObject specUri) throws IOException {
        throw new UnsupportedOperationException();
    }
}

