/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.TaskState;

public class JobExecutionEventSubmitter {
    private final EventSubmitter eventSubmitter;
    private static final String UNKNOWN_VALUE = "UNKNOWN";

    public void submitJobExecutionEvents(JobState jobState) {
        this.submitJobStateEvent(jobState);
        this.submitTaskStateEvents(jobState);
    }

    private void submitJobStateEvent(JobState jobState) {
        ImmutableMap.Builder jobMetadataBuilder = new ImmutableMap.Builder();
        jobMetadataBuilder.put((Object)"jobId", (Object)jobState.getJobId());
        jobMetadataBuilder.put((Object)"jobName", (Object)jobState.getJobName());
        jobMetadataBuilder.put((Object)"jobBeginTime", (Object)Long.toString(jobState.getStartTime()));
        jobMetadataBuilder.put((Object)"jobEndTime", (Object)Long.toString(jobState.getEndTime()));
        jobMetadataBuilder.put((Object)"jobState", (Object)jobState.getState().toString());
        jobMetadataBuilder.put((Object)"jobLaunchedTasks", (Object)Integer.toString(jobState.getTaskCount()));
        jobMetadataBuilder.put((Object)"jobCompletedTasks", (Object)Integer.toString(jobState.getCompletedTasks()));
        jobMetadataBuilder.put((Object)"jobLauncherType", (Object)jobState.getLauncherType().toString());
        jobMetadataBuilder.put((Object)"jobTrackingURL", jobState.getTrackingURL().or((Object)UNKNOWN_VALUE));
        jobMetadataBuilder.put((Object)"eventType", (Object)"JobStateEvent");
        this.eventSubmitter.submit("JobStateEvent", (Map)jobMetadataBuilder.build());
    }

    private void submitTaskStateEvents(JobState jobState) {
        ImmutableMap.Builder jobMetadataBuilder = new ImmutableMap.Builder();
        jobMetadataBuilder.put((Object)"jobId", (Object)jobState.getJobId());
        jobMetadataBuilder.put((Object)"jobName", (Object)jobState.getJobName());
        jobMetadataBuilder.put((Object)"jobTrackingURL", jobState.getTrackingURL().or((Object)UNKNOWN_VALUE));
        ImmutableMap jobMetadata = jobMetadataBuilder.build();
        for (TaskState taskState : jobState.getTaskStates()) {
            this.submitTaskStateEvent(taskState, (Map<String, String>)jobMetadata);
        }
    }

    private void submitTaskStateEvent(TaskState taskState, Map<String, String> jobMetadata) {
        ImmutableMap.Builder taskMetadataBuilder = new ImmutableMap.Builder();
        taskMetadataBuilder.putAll(jobMetadata);
        taskMetadataBuilder.put((Object)"taskId", (Object)taskState.getTaskId());
        taskMetadataBuilder.put((Object)"taskStartTime", (Object)Long.toString(taskState.getStartTime()));
        taskMetadataBuilder.put((Object)"taskEndTime", (Object)Long.toString(taskState.getEndTime()));
        taskMetadataBuilder.put((Object)"taskWorkingState", (Object)taskState.getWorkingState().toString());
        taskMetadataBuilder.put((Object)"taskFailureContext", taskState.getTaskFailureException().or((Object)UNKNOWN_VALUE));
        taskMetadataBuilder.put((Object)"eventType", (Object)"TaskStateEvent");
        this.eventSubmitter.submit("TaskStateEvent", (Map)taskMetadataBuilder.build());
    }

    public JobExecutionEventSubmitter(EventSubmitter eventSubmitter) {
        this.eventSubmitter = eventSubmitter;
    }
}

