/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.gobblin.runtime.ForkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkThrowableHolder {
    private static final Logger log = LoggerFactory.getLogger(ForkThrowableHolder.class);
    Map<Integer, Throwable> throwables = Maps.newHashMap();

    public void setThrowable(int forkIdx, Throwable e) {
        this.throwables.put(forkIdx, e);
    }

    public Optional<Throwable> getThrowable(int forkIdx) {
        return Optional.fromNullable((Object)this.throwables.get(forkIdx));
    }

    public boolean isEmpty() {
        return this.throwables.isEmpty();
    }

    public ForkException getAggregatedException(List<Integer> failedForkIds, String taskId) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Fork branches " + failedForkIds + " failed for task " + taskId + "\n");
        for (Integer idx : failedForkIds) {
            stringBuffer.append("<Fork " + idx + ">\n");
            if (this.throwables.containsKey(idx)) {
                stringBuffer.append(ExceptionUtils.getFullStackTrace((Throwable)this.throwables.get(idx)));
                continue;
            }
            stringBuffer.append("Cannot find throwable entry in ForkThrowableHolder\n");
        }
        return new ForkException(stringBuffer.toString());
    }
}

