/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_catalog;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.typesafe.config.Config;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.MutableSpecCatalog;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecCatalog;
import org.apache.gobblin.runtime.api.SpecCatalogListener;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.api.SpecSerDe;
import org.apache.gobblin.runtime.api.SpecStore;
import org.apache.gobblin.runtime.api.TopologySpec;
import org.apache.gobblin.runtime.spec_catalog.AddSpecResponse;
import org.apache.gobblin.runtime.spec_catalog.SpecCatalogListenersList;
import org.apache.gobblin.runtime.spec_serde.JavaSpecSerDe;
import org.apache.gobblin.runtime.spec_store.FSSpecStore;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.callbacks.CallbackResult;
import org.apache.gobblin.util.callbacks.CallbacksDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class TopologyCatalog
extends AbstractIdleService
implements SpecCatalog,
MutableSpecCatalog {
    public static final String DEFAULT_TOPOLOGYSPEC_STORE_CLASS = FSSpecStore.class.getCanonicalName();
    public static final String DEFAULT_TOPOLOGYSPEC_SERDE_CLASS = JavaSpecSerDe.class.getCanonicalName();
    protected final SpecCatalogListenersList listeners;
    protected final Logger log;
    protected final MetricContext metricContext;
    protected final SpecCatalog.StandardMetrics metrics;
    protected final SpecStore specStore;
    protected CountDownLatch initComplete = new CountDownLatch(1);
    private final ClassAliasResolver<SpecStore> aliasResolver;

    public TopologyCatalog(Config config) {
        this(config, (Optional<Logger>)Optional.absent());
    }

    public TopologyCatalog(Config config, Optional<Logger> log) {
        this(config, log, (Optional<MetricContext>)Optional.absent(), true);
    }

    public TopologyCatalog(Config config, GobblinInstanceEnvironment env) {
        this(config, (Optional<Logger>)Optional.of((Object)env.getLog()), (Optional<MetricContext>)Optional.of((Object)env.getMetricContext()), env.isInstrumentationEnabled());
    }

    public TopologyCatalog(Config config, Optional<Logger> log, Optional<MetricContext> parentMetricContext, boolean instrumentationEnabled) {
        this.log = log.isPresent() ? (Logger)log.get() : LoggerFactory.getLogger(this.getClass());
        this.listeners = new SpecCatalogListenersList(log);
        if (instrumentationEnabled) {
            MetricContext realParentCtx = (MetricContext)parentMetricContext.or((Object)Instrumented.getMetricContext((State)new State(), this.getClass()));
            this.metricContext = realParentCtx.childBuilder(TopologyCatalog.class.getSimpleName()).build();
            this.metrics = new SpecCatalog.StandardMetrics(this, (Optional<Config>)Optional.of((Object)config));
            this.addListener(this.metrics);
        } else {
            this.metricContext = null;
            this.metrics = null;
        }
        this.aliasResolver = new ClassAliasResolver(SpecStore.class);
        try {
            Config newConfig = config;
            if (config.hasPath("topologySpec.store.dir")) {
                newConfig = config.withValue("specStore.fs.dir", config.getValue("topologySpec.store.dir"));
            }
            String specStoreClassName = ConfigUtils.getString((Config)config, (String)"topologySpec.store.class", (String)DEFAULT_TOPOLOGYSPEC_STORE_CLASS);
            this.log.info("Using SpecStore class name/alias " + specStoreClassName);
            String specSerDeClassName = ConfigUtils.getString((Config)config, (String)"topologySpec.serde.class", (String)DEFAULT_TOPOLOGYSPEC_SERDE_CLASS);
            this.log.info("Using SpecSerDe class name/alias " + specSerDeClassName);
            SpecSerDe specSerDe = (SpecSerDe)ConstructorUtils.invokeConstructor(Class.forName(new ClassAliasResolver(SpecSerDe.class).resolve(specSerDeClassName)), (Object[])new Object[0]);
            this.specStore = (SpecStore)ConstructorUtils.invokeConstructor(Class.forName(this.aliasResolver.resolve(specStoreClassName)), (Object[])new Object[]{newConfig, specSerDe});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected void startUp() throws Exception {
        this.notifyAllListeners();
    }

    protected void shutDown() throws Exception {
        this.listeners.close();
    }

    protected void notifyAllListeners() {
        for (Spec spec : this.getSpecs()) {
            this.listeners.onAddSpec(spec);
        }
    }

    @Override
    public void addListener(SpecCatalogListener specListener) {
        Preconditions.checkNotNull((Object)specListener);
        this.listeners.addListener(specListener);
        if (this.state() == Service.State.RUNNING) {
            for (Spec spec : this.getSpecs()) {
                SpecCatalogListener.AddSpecCallback addJobCallback = new SpecCatalogListener.AddSpecCallback(spec);
                this.listeners.callbackOneListener((Function<SpecCatalogListener, AddSpecResponse>)addJobCallback, specListener);
            }
        }
    }

    @Override
    public void removeListener(SpecCatalogListener specCatalogListener) {
        this.listeners.removeListener(specCatalogListener);
    }

    @Override
    public void registerWeakSpecCatalogListener(SpecCatalogListener specCatalogListener) {
        this.listeners.registerWeakSpecCatalogListener(specCatalogListener);
    }

    @Nonnull
    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public boolean isInstrumentationEnabled() {
        return null != this.metricContext;
    }

    public List<Tag<?>> generateTags(State state) {
        return Collections.emptyList();
    }

    public void switchMetricContext(List<Tag<?>> tags) {
        throw new UnsupportedOperationException();
    }

    public void switchMetricContext(MetricContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SpecCatalog.StandardMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public Collection<Spec> getSpecs() {
        try {
            return this.specStore.getSpecs();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot retrieve Specs from Spec store", e);
        }
    }

    @Override
    public Spec getSpecs(URI uri) throws SpecNotFoundException {
        try {
            return this.specStore.getSpec(uri);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot retrieve Spec from Spec store for URI: " + uri, e);
        }
    }

    @Override
    public Map<String, AddSpecResponse> put(Spec spec) {
        HashMap<String, AddSpecResponse> responseMap = new HashMap<String, AddSpecResponse>();
        try {
            Preconditions.checkState((this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)String.format("%s is not running.", this.getClass().getName()));
            Preconditions.checkNotNull((Object)spec);
            this.log.info(String.format("Adding TopologySpec with URI: %s and Config: %s", spec.getUri(), ((TopologySpec)spec).getConfigAsProperties()));
            this.specStore.addSpec(spec);
            AddSpecResponse response = this.listeners.onAddSpec(spec);
            for (Map.Entry entry : ((CallbacksDispatcher.CallbackResults)response.getValue()).getSuccesses().entrySet()) {
                responseMap.put(((SpecCatalogListener)entry.getKey()).getName(), (AddSpecResponse)((CallbackResult)entry.getValue()).getResult());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot add Spec to Spec store: " + spec, e);
        }
        return responseMap;
    }

    public void remove(URI uri) {
        this.remove(uri, new Properties());
    }

    @Override
    public void remove(URI uri, Properties headers) {
        try {
            Preconditions.checkState((this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)String.format("%s is not running.", this.getClass().getName()));
            Preconditions.checkNotNull((Object)uri);
            this.log.info(String.format("Removing TopologySpec with URI: %s", uri));
            this.listeners.onDeleteSpec(uri, "", headers);
            this.specStore.deleteSpec(uri);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot delete Spec from Spec store for URI: " + uri, e);
        }
    }

    public CountDownLatch getInitComplete() {
        return this.initComplete;
    }
}

