/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.locks;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.runtime.locks.FileBasedJobLock;
import org.apache.gobblin.runtime.locks.JobLock;
import org.apache.gobblin.runtime.locks.JobLockEventListener;
import org.apache.gobblin.runtime.locks.JobLockException;
import org.apache.gobblin.runtime.locks.ListenableJobLock;

public class LegacyJobLockFactoryManager {
    public static JobLock getJobLock(Properties properties, JobLockEventListener jobLockEventListener) throws JobLockException {
        JobLock jobLock;
        Preconditions.checkNotNull((Object)properties);
        Preconditions.checkNotNull((Object)jobLockEventListener);
        if (properties.containsKey("job.lock.type")) {
            try {
                Class<?> jobLockClass = Class.forName(properties.getProperty("job.lock.type", FileBasedJobLock.class.getName()));
                jobLock = (JobLock)ConstructorUtils.invokeConstructor(jobLockClass, (Object[])new Object[]{properties});
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JobLockException(e);
            }
        } else {
            jobLock = new FileBasedJobLock(properties);
        }
        if (jobLock instanceof ListenableJobLock) {
            ((ListenableJobLock)jobLock).setEventListener(jobLockEventListener);
        }
        return jobLock;
    }
}

