/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.listeners;

import org.apache.commons.mail.EmailException;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.runtime.JobContext;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.listeners.AbstractJobListener;
import org.apache.gobblin.util.EmailUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="EmailNotificationJobListener")
public class EmailNotificationJobListener
extends AbstractJobListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailNotificationJobListener.class);

    @Override
    public void onJobCompletion(JobContext jobContext) {
        JobState jobState = jobContext.getJobState();
        boolean alertEmailEnabled = Boolean.valueOf(jobState.getProp("email.alert.enabled", Boolean.toString(false)));
        boolean notificationEmailEnabled = Boolean.valueOf(jobState.getProp("email.notification.enabled", Boolean.toString(false)));
        if (jobState.getState() == JobState.RunningState.FAILED) {
            int failures = jobState.getPropAsInt("job.failures", 0);
            int maxFailures = jobState.getPropAsInt("job.max.failures", 1);
            if (alertEmailEnabled && failures >= maxFailures) {
                try {
                    EmailUtils.sendJobFailureAlertEmail((String)jobState.getJobName(), (String)jobState.toString(), (int)failures, (State)jobState);
                }
                catch (EmailException ee) {
                    LOGGER.error("Failed to send job failure alert email for job " + jobState.getJobId(), (Throwable)ee);
                }
                return;
            }
        }
        if (notificationEmailEnabled) {
            try {
                EmailUtils.sendJobCompletionEmail((String)jobState.getJobId(), (String)jobState.toString(), (String)jobState.getState().toString(), (State)jobState);
            }
            catch (EmailException ee) {
                LOGGER.error("Failed to send job completion notification email for job " + jobState.getJobId(), (Throwable)ee);
            }
        }
    }

    @Override
    public void onJobCancellation(JobContext jobContext) {
        JobState jobState = jobContext.getJobState();
        boolean notificationEmailEnabled = Boolean.valueOf(jobState.getProp("email.notification.enabled", Boolean.toString(false)));
        if (notificationEmailEnabled) {
            try {
                EmailUtils.sendJobCancellationEmail((String)jobState.getJobId(), (String)jobState.toString(), (State)jobState);
            }
            catch (EmailException ee) {
                LOGGER.error("Failed to send job cancellation notification email for job " + jobState.getJobId(), (Throwable)ee);
            }
        }
    }
}

