/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import java.beans.ConstructorProperties;
import java.net.URI;
import org.apache.gobblin.runtime.api.SpecSearchObject;
import org.apache.gobblin.service.FlowId;

public class FlowSpecSearchObject
implements SpecSearchObject {
    private final URI flowSpecUri;
    private final String flowGroup;
    private final String flowName;
    private final String templateURI;
    private final String userToProxy;
    private final String sourceIdentifier;
    private final String destinationIdentifier;
    private final String schedule;
    private final String modifiedTimestamp;
    private final Boolean isRunImmediately;
    private final String owningGroup;
    private final String propertyFilter;

    public static FlowSpecSearchObject fromFlowId(FlowId flowId) {
        return FlowSpecSearchObject.builder().flowGroup(flowId.getFlowGroup()).flowName(flowId.getFlowName()).build();
    }

    public static FlowSpecSearchObjectBuilder builder() {
        return new FlowSpecSearchObjectBuilder();
    }

    public URI getFlowSpecUri() {
        return this.flowSpecUri;
    }

    public String getFlowGroup() {
        return this.flowGroup;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getTemplateURI() {
        return this.templateURI;
    }

    public String getUserToProxy() {
        return this.userToProxy;
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public String getDestinationIdentifier() {
        return this.destinationIdentifier;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public String getModifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public Boolean getIsRunImmediately() {
        return this.isRunImmediately;
    }

    public String getOwningGroup() {
        return this.owningGroup;
    }

    public String getPropertyFilter() {
        return this.propertyFilter;
    }

    public String toString() {
        return "FlowSpecSearchObject(flowSpecUri=" + this.getFlowSpecUri() + ", flowGroup=" + this.getFlowGroup() + ", flowName=" + this.getFlowName() + ", templateURI=" + this.getTemplateURI() + ", userToProxy=" + this.getUserToProxy() + ", sourceIdentifier=" + this.getSourceIdentifier() + ", destinationIdentifier=" + this.getDestinationIdentifier() + ", schedule=" + this.getSchedule() + ", modifiedTimestamp=" + this.getModifiedTimestamp() + ", isRunImmediately=" + this.getIsRunImmediately() + ", owningGroup=" + this.getOwningGroup() + ", propertyFilter=" + this.getPropertyFilter() + ")";
    }

    @ConstructorProperties(value={"flowSpecUri", "flowGroup", "flowName", "templateURI", "userToProxy", "sourceIdentifier", "destinationIdentifier", "schedule", "modifiedTimestamp", "isRunImmediately", "owningGroup", "propertyFilter"})
    public FlowSpecSearchObject(URI flowSpecUri, String flowGroup, String flowName, String templateURI, String userToProxy, String sourceIdentifier, String destinationIdentifier, String schedule, String modifiedTimestamp, Boolean isRunImmediately, String owningGroup, String propertyFilter) {
        this.flowSpecUri = flowSpecUri;
        this.flowGroup = flowGroup;
        this.flowName = flowName;
        this.templateURI = templateURI;
        this.userToProxy = userToProxy;
        this.sourceIdentifier = sourceIdentifier;
        this.destinationIdentifier = destinationIdentifier;
        this.schedule = schedule;
        this.modifiedTimestamp = modifiedTimestamp;
        this.isRunImmediately = isRunImmediately;
        this.owningGroup = owningGroup;
        this.propertyFilter = propertyFilter;
    }

    public static class FlowSpecSearchObjectBuilder {
        private URI flowSpecUri;
        private String flowGroup;
        private String flowName;
        private String templateURI;
        private String userToProxy;
        private String sourceIdentifier;
        private String destinationIdentifier;
        private String schedule;
        private String modifiedTimestamp;
        private Boolean isRunImmediately;
        private String owningGroup;
        private String propertyFilter;

        FlowSpecSearchObjectBuilder() {
        }

        public FlowSpecSearchObjectBuilder flowSpecUri(URI flowSpecUri) {
            this.flowSpecUri = flowSpecUri;
            return this;
        }

        public FlowSpecSearchObjectBuilder flowGroup(String flowGroup) {
            this.flowGroup = flowGroup;
            return this;
        }

        public FlowSpecSearchObjectBuilder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public FlowSpecSearchObjectBuilder templateURI(String templateURI) {
            this.templateURI = templateURI;
            return this;
        }

        public FlowSpecSearchObjectBuilder userToProxy(String userToProxy) {
            this.userToProxy = userToProxy;
            return this;
        }

        public FlowSpecSearchObjectBuilder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public FlowSpecSearchObjectBuilder destinationIdentifier(String destinationIdentifier) {
            this.destinationIdentifier = destinationIdentifier;
            return this;
        }

        public FlowSpecSearchObjectBuilder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public FlowSpecSearchObjectBuilder modifiedTimestamp(String modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public FlowSpecSearchObjectBuilder isRunImmediately(Boolean isRunImmediately) {
            this.isRunImmediately = isRunImmediately;
            return this;
        }

        public FlowSpecSearchObjectBuilder owningGroup(String owningGroup) {
            this.owningGroup = owningGroup;
            return this;
        }

        public FlowSpecSearchObjectBuilder propertyFilter(String propertyFilter) {
            this.propertyFilter = propertyFilter;
            return this;
        }

        public FlowSpecSearchObject build() {
            return new FlowSpecSearchObject(this.flowSpecUri, this.flowGroup, this.flowName, this.templateURI, this.userToProxy, this.sourceIdentifier, this.destinationIdentifier, this.schedule, this.modifiedTimestamp, this.isRunImmediately, this.owningGroup, this.propertyFilter);
        }

        public String toString() {
            return "FlowSpecSearchObject.FlowSpecSearchObjectBuilder(flowSpecUri=" + this.flowSpecUri + ", flowGroup=" + this.flowGroup + ", flowName=" + this.flowName + ", templateURI=" + this.templateURI + ", userToProxy=" + this.userToProxy + ", sourceIdentifier=" + this.sourceIdentifier + ", destinationIdentifier=" + this.destinationIdentifier + ", schedule=" + this.schedule + ", modifiedTimestamp=" + this.modifiedTimestamp + ", isRunImmediately=" + this.isRunImmediately + ", owningGroup=" + this.owningGroup + ", propertyFilter=" + this.propertyFilter + ")";
        }
    }
}

