/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.gson.stream.JsonWriter;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.StringMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.rest.Metric;
import org.apache.gobblin.rest.MetricArray;
import org.apache.gobblin.rest.MetricTypeEnum;
import org.apache.gobblin.rest.Table;
import org.apache.gobblin.rest.TableTypeEnum;
import org.apache.gobblin.rest.TaskExecutionInfo;
import org.apache.gobblin.rest.TaskStateEnum;
import org.apache.gobblin.runtime.job.TaskProgress;
import org.apache.gobblin.runtime.util.MetricGroup;
import org.apache.gobblin.runtime.util.TaskMetrics;
import org.apache.gobblin.source.workunit.Extract;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.hadoop.io.Text;

public class TaskState
extends WorkUnitState
implements TaskProgress {
    private static final String RECORDS = "records";
    private static final String RECORDS_PER_SECOND = "recordsPerSec";
    private static final String BYTES = "bytes";
    private static final String BYTES_PER_SECOND = "bytesPerSec";
    private String jobId;
    private String taskId;
    private String taskKey;
    private Optional<String> taskAttemptId;
    private long startTime = 0L;
    private long endTime = 0L;
    private long duration;

    public TaskState() {
    }

    public TaskState(WorkUnitState workUnitState) {
        super(workUnitState.getWorkunit(), workUnitState.getJobState(), workUnitState.getTaskBrokerNullable());
        this.addAll((State)workUnitState);
        this.jobId = workUnitState.getProp("job.id");
        this.taskId = workUnitState.getProp("task.id");
        this.taskKey = workUnitState.getProp("task.key", "unknown_task_key");
        this.taskAttemptId = Optional.fromNullable((Object)workUnitState.getProp("task.AttemptId"));
        this.setId(this.taskId);
    }

    public TaskState(TaskState taskState) {
        super(taskState.getWorkunit(), taskState.getJobState(), taskState.getTaskBrokerNullable());
        this.addAll((State)taskState);
        this.jobId = taskState.getProp("job.id");
        this.taskId = taskState.getProp("task.id");
        this.taskAttemptId = taskState.getTaskAttemptId();
        this.setId(this.taskId);
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getTaskDuration() {
        return this.duration;
    }

    public void setTaskDuration(long duration) {
        this.duration = duration;
    }

    public Optional<String> getTaskFailureException() {
        return Optional.fromNullable((Object)this.getProp("task.failure.exception"));
    }

    public void setTaskFailureException(Throwable taskFailureException) {
        if (!this.contains("task.failure.exception")) {
            this.setProp("task.failure.exception", Throwables.getStackTraceAsString((Throwable)taskFailureException));
        }
    }

    @Override
    public boolean isCompleted() {
        WorkUnitState.WorkingState state = this.getWorkingState();
        return state == WorkUnitState.WorkingState.SUCCESSFUL || state == WorkUnitState.WorkingState.COMMITTED || state == WorkUnitState.WorkingState.FAILED;
    }

    public synchronized void updateRecordMetrics(long recordsWritten, int branchIndex) {
        TaskMetrics metrics = TaskMetrics.get(this);
        String forkBranchId = TaskMetrics.taskInstanceRemoved(this.taskId);
        Counter taskRecordCounter = metrics.getCounter(MetricGroup.TASK.name(), new String[]{forkBranchId, RECORDS});
        long inc = recordsWritten - taskRecordCounter.getCount();
        taskRecordCounter.inc(inc);
        metrics.getMeter(MetricGroup.TASK.name(), new String[]{forkBranchId, RECORDS_PER_SECOND}).mark(inc);
        metrics.getCounter(MetricGroup.JOB.name(), new String[]{this.jobId, RECORDS}).inc(inc);
        metrics.getMeter(MetricGroup.JOB.name(), new String[]{this.jobId, RECORDS_PER_SECOND}).mark(inc);
    }

    public synchronized void updateByteMetrics(long bytesWritten, int branchIndex) {
        TaskMetrics metrics = TaskMetrics.get(this);
        String forkBranchId = TaskMetrics.taskInstanceRemoved(this.taskId);
        Counter taskByteCounter = metrics.getCounter(MetricGroup.TASK.name(), new String[]{forkBranchId, BYTES});
        long inc = bytesWritten - taskByteCounter.getCount();
        taskByteCounter.inc(inc);
        metrics.getMeter(MetricGroup.TASK.name(), new String[]{forkBranchId, BYTES_PER_SECOND}).mark(inc);
        metrics.getCounter(MetricGroup.JOB.name(), new String[]{this.jobId, BYTES}).inc(inc);
        metrics.getMeter(MetricGroup.JOB.name(), new String[]{this.jobId, BYTES_PER_SECOND}).mark(inc);
    }

    public void adjustJobMetricsOnRetry(int branches) {
        TaskMetrics metrics = TaskMetrics.get(this);
        for (int i = 0; i < branches; ++i) {
            String forkBranchId = ForkOperatorUtils.getForkId((String)this.taskId, (int)i);
            long recordsWritten = metrics.getCounter(MetricGroup.TASK.name(), new String[]{forkBranchId, RECORDS}).getCount();
            long bytesWritten = metrics.getCounter(MetricGroup.TASK.name(), new String[]{forkBranchId, BYTES}).getCount();
            metrics.getCounter(MetricGroup.JOB.name(), new String[]{this.jobId, RECORDS}).dec(recordsWritten);
            metrics.getCounter(MetricGroup.JOB.name(), new String[]{this.jobId, BYTES}).dec(bytesWritten);
        }
    }

    public void readFields(DataInput in) throws IOException {
        Text text = new Text();
        text.readFields(in);
        this.jobId = text.toString().intern();
        text.readFields(in);
        this.taskId = text.toString().intern();
        this.taskAttemptId = Optional.absent();
        this.setId(this.taskId);
        this.startTime = in.readLong();
        this.endTime = in.readLong();
        this.duration = in.readLong();
        super.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        Text text = new Text();
        text.set(this.jobId);
        text.write(out);
        text.set(this.taskId);
        text.write(out);
        out.writeLong(this.startTime);
        out.writeLong(this.endTime);
        out.writeLong(this.duration);
        super.write(out);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TaskState)) {
            return false;
        }
        TaskState other = (TaskState)object;
        return super.equals((Object)other) && this.jobId.equals(other.jobId) && this.taskId.equals(other.taskId);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.jobId.hashCode();
        result = 31 * result + this.taskId.hashCode();
        return result;
    }

    public void toJson(JsonWriter jsonWriter, boolean keepConfig) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name("task id").value(this.getTaskId()).name("task state").value(this.getWorkingState().name()).name("start time").value(this.getStartTime()).name("end time").value(this.getEndTime()).name("duration").value(this.getTaskDuration()).name("retry count").value((long)this.getPropAsInt("task.retries", 0));
        if (this.getTaskFailureException().isPresent()) {
            jsonWriter.name("exception").value((String)this.getTaskFailureException().get());
        }
        if (keepConfig) {
            jsonWriter.name("properties");
            jsonWriter.beginObject();
            for (String key : this.getPropertyNames()) {
                jsonWriter.name(key).value(this.getProp(key));
            }
            jsonWriter.endObject();
        }
        jsonWriter.endObject();
    }

    public TaskExecutionInfo toTaskExecutionInfo() {
        TaskExecutionInfo taskExecutionInfo = new TaskExecutionInfo();
        taskExecutionInfo.setJobId(this.jobId);
        taskExecutionInfo.setTaskId(this.taskId);
        if (this.startTime > 0L) {
            taskExecutionInfo.setStartTime(this.startTime);
        }
        if (this.endTime > 0L) {
            taskExecutionInfo.setEndTime(this.endTime);
        }
        taskExecutionInfo.setDuration(this.duration);
        taskExecutionInfo.setState(TaskStateEnum.valueOf((String)this.getWorkingState().name()));
        if (this.contains("task.failure.exception")) {
            taskExecutionInfo.setFailureException(this.getProp("task.failure.exception"));
        }
        taskExecutionInfo.setHighWatermark(this.getHighWaterMark());
        Table table = new Table();
        Extract extract = this.getExtract();
        table.setNamespace(extract.getNamespace());
        table.setName(extract.getTable());
        if (extract.hasType()) {
            table.setType(TableTypeEnum.valueOf((String)extract.getType().name()));
        }
        taskExecutionInfo.setTable(table);
        TaskMetrics taskMetrics = TaskMetrics.get(this);
        MetricArray metricArray = new MetricArray();
        for (Map.Entry entry : taskMetrics.getMetricContext().getCounters().entrySet()) {
            Metric counter = new Metric();
            counter.setGroup(MetricGroup.TASK.name());
            counter.setName((String)entry.getKey());
            counter.setType(MetricTypeEnum.valueOf((String)GobblinMetrics.MetricType.COUNTER.name()));
            counter.setValue(Long.toString(((Counter)entry.getValue()).getCount()));
            metricArray.add((DataTemplate)counter);
        }
        for (Map.Entry entry : taskMetrics.getMetricContext().getMeters().entrySet()) {
            Metric meter = new Metric();
            meter.setGroup(MetricGroup.TASK.name());
            meter.setName((String)entry.getKey());
            meter.setType(MetricTypeEnum.valueOf((String)GobblinMetrics.MetricType.METER.name()));
            meter.setValue(Double.toString(((Meter)entry.getValue()).getMeanRate()));
            metricArray.add((DataTemplate)meter);
        }
        for (Map.Entry entry : taskMetrics.getMetricContext().getGauges().entrySet()) {
            Metric gauge = new Metric();
            gauge.setGroup(MetricGroup.TASK.name());
            gauge.setName((String)entry.getKey());
            gauge.setType(MetricTypeEnum.valueOf((String)GobblinMetrics.MetricType.GAUGE.name()));
            gauge.setValue(((Gauge)entry.getValue()).getValue().toString());
            metricArray.add((DataTemplate)gauge);
        }
        taskExecutionInfo.setMetrics(metricArray);
        HashMap taskProperties = Maps.newHashMap();
        for (String name : this.getPropertyNames()) {
            String value = this.getProp(name);
            if (Strings.isNullOrEmpty((String)value)) continue;
            taskProperties.put(name, value);
        }
        taskExecutionInfo.setTaskProperties(new StringMap((Map)taskProperties));
        return taskExecutionInfo;
    }

    public Optional<String> getTaskAttemptId() {
        return this.taskAttemptId;
    }
}

