/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.runtime.cli.CliApplication;
import org.apache.gobblin.runtime.cli.CliObjectOption;
import org.apache.gobblin.runtime.cli.CliObjectSupport;
import org.apache.gobblin.runtime.cli.ConstructorAndPublicMethodsCliObjectFactory;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="stateMigration", description="Command line tools for migrating state store")
public class StateStoreMigrationCli
implements CliApplication {
    private static final Logger log = LoggerFactory.getLogger(StateStoreMigrationCli.class);
    private static final String SOURCE_KEY = "source";
    private static final String DESTINATION_KEY = "destination";
    private static final String JOB_NAME_KEY = "jobName";
    private static final String MIGRATE_ALL_JOBS = "migrateAllJobs";
    private static final String DEFAULT_MIGRATE_ALL_JOBS = "false";

    public void run(String[] args) throws Exception {
        ConstructorAndPublicMethodsCliObjectFactory factory = new ConstructorAndPublicMethodsCliObjectFactory(Command.class);
        Command command = (Command)factory.buildObject(args, 1, true, args[0]);
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        FSDataInputStream inputStream = fs.open(command.path);
        Config config = ConfigFactory.parseReader((Reader)new InputStreamReader((InputStream)inputStream, Charset.defaultCharset()));
        Preconditions.checkNotNull((Object)config.getObject(SOURCE_KEY));
        Preconditions.checkNotNull((Object)config.getObject(DESTINATION_KEY));
        DatasetStateStore dstDatasetStateStore = DatasetStateStore.buildDatasetStateStore((Config)config.getConfig(DESTINATION_KEY));
        DatasetStateStore srcDatasetStateStore = DatasetStateStore.buildDatasetStateStore((Config)config.getConfig(SOURCE_KEY));
        if (ConfigUtils.getBoolean((Config)config, (String)MIGRATE_ALL_JOBS, (boolean)Boolean.valueOf(DEFAULT_MIGRATE_ALL_JOBS))) {
            List jobNames = srcDatasetStateStore.getStoreNames(Predicates.alwaysTrue());
            for (String jobName : jobNames) {
                StateStoreMigrationCli.migrateStateForJob(srcDatasetStateStore, dstDatasetStateStore, jobName, command.deleteSourceStateStore);
            }
        } else {
            Preconditions.checkNotNull((Object)config.getString(JOB_NAME_KEY));
            StateStoreMigrationCli.migrateStateForJob(srcDatasetStateStore, dstDatasetStateStore, config.getString(JOB_NAME_KEY), command.deleteSourceStateStore);
        }
    }

    private static void migrateStateForJob(DatasetStateStore srcDatasetStateStore, DatasetStateStore dstDatasetStateStore, String jobName, boolean deleteFromSource) throws IOException {
        Map map = srcDatasetStateStore.getLatestDatasetStatesByUrns(jobName);
        for (Map.Entry entry : map.entrySet()) {
            dstDatasetStateStore.persistDatasetState((String)entry.getKey(), (State)entry.getValue());
        }
        if (deleteFromSource) {
            try {
                srcDatasetStateStore.delete(jobName);
            }
            catch (IOException ioe) {
                log.warn("The source state store has been deleted", (Throwable)ioe);
            }
        }
    }

    public static class Command {
        private final Path path;
        private boolean deleteSourceStateStore = false;

        @CliObjectSupport(argumentNames={"configPath"})
        public Command(String path) throws URISyntaxException, IOException {
            this.path = new Path(path);
        }

        @CliObjectOption
        public void deleteSourceStateStore() {
            this.deleteSourceStateStore = true;
        }
    }
}

