/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.JobLauncher;
import org.apache.gobblin.runtime.local.LocalJobLauncher;
import org.apache.gobblin.runtime.mapreduce.MRJobLauncher;
import org.apache.gobblin.util.JobConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLauncherFactory {
    private static final Logger log = LoggerFactory.getLogger(JobLauncherFactory.class);

    @Nonnull
    public static JobLauncher newJobLauncher(Properties sysProps, Properties jobProps) throws Exception {
        return JobLauncherFactory.newJobLauncher(sysProps, jobProps, null);
    }

    @Nonnull
    public static JobLauncher newJobLauncher(Properties sysProps, Properties jobProps, SharedResourcesBroker<GobblinScopeTypes> instanceBroker) throws Exception {
        return JobLauncherFactory.newJobLauncher(sysProps, jobProps, instanceBroker, ImmutableList.of());
    }

    @Nonnull
    public static JobLauncher newJobLauncher(Properties sysProps, Properties jobProps, SharedResourcesBroker<GobblinScopeTypes> instanceBroker, List<? extends Tag<?>> metadataTags) throws Exception {
        String launcherTypeValue = sysProps.getProperty("launcher.type", JobLauncherType.LOCAL.name());
        return JobLauncherFactory.newJobLauncher(sysProps, jobProps, launcherTypeValue, instanceBroker, metadataTags);
    }

    public static JobLauncher newJobLauncher(Properties sysProps, Properties jobProps, String launcherTypeValue, SharedResourcesBroker<GobblinScopeTypes> instanceBroker) {
        return JobLauncherFactory.newJobLauncher(sysProps, jobProps, launcherTypeValue, instanceBroker, ImmutableList.of());
    }

    public static JobLauncher newJobLauncher(Properties sysProps, Properties jobProps, String launcherTypeValue, SharedResourcesBroker<GobblinScopeTypes> instanceBroker, List<? extends Tag<?>> metadataTags) {
        Optional launcherType = Enums.getIfPresent(JobLauncherType.class, (String)launcherTypeValue);
        try {
            if (launcherType.isPresent()) {
                switch ((JobLauncherType)((Object)launcherType.get())) {
                    case LOCAL: {
                        return new LocalJobLauncher(JobConfigurationUtils.combineSysAndJobProperties((Properties)sysProps, (Properties)jobProps), instanceBroker, metadataTags);
                    }
                    case MAPREDUCE: {
                        return new MRJobLauncher(JobConfigurationUtils.combineSysAndJobProperties((Properties)sysProps, (Properties)jobProps), instanceBroker, metadataTags);
                    }
                }
                throw new RuntimeException("Unsupported job launcher type: " + ((JobLauncherType)((Object)launcherType.get())).name());
            }
            Class<?> launcherClass = Class.forName(launcherTypeValue);
            return (JobLauncher)launcherClass.getDeclaredConstructor(Properties.class).newInstance(JobConfigurationUtils.combineSysAndJobProperties((Properties)sysProps, (Properties)jobProps));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create job launcher: " + e, e);
        }
    }

    public static enum JobLauncherType {
        LOCAL,
        MAPREDUCE,
        YARN;

    }
}

