/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_catalog;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Service;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import java.io.IOException;
import java.net.URI;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecNotFoundException;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.job_catalog.FSJobCatalog;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonObservingFSJobCatalog
extends FSJobCatalog {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonObservingFSJobCatalog.class);

    public NonObservingFSJobCatalog(Config sysConfig) throws IOException {
        super(sysConfig.withValue("jobconf.monitor.interval", ConfigValueFactory.fromAnyRef((Object)-1L)));
    }

    public NonObservingFSJobCatalog(GobblinInstanceEnvironment env) throws IOException {
        super(env);
    }

    public NonObservingFSJobCatalog(Config sysConfig, Optional<MetricContext> parentMetricContext, boolean instrumentationEnabled) throws IOException {
        super(sysConfig.withValue("jobconf.monitor.interval", ConfigValueFactory.fromAnyRef((Object)-1L)), parentMetricContext, instrumentationEnabled);
    }

    @Override
    public synchronized void put(JobSpec jobSpec) {
        Preconditions.checkState((this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)String.format("%s is not running.", this.getClass().getName()));
        Preconditions.checkNotNull((Object)jobSpec);
        try {
            long startTime = System.currentTimeMillis();
            Path jobSpecPath = this.getPathForURI(this.jobConfDirPath, jobSpec.getUri());
            boolean isUpdate = this.fs.exists(jobSpecPath);
            this.materializedJobSpec(jobSpecPath, jobSpec, this.fs);
            this.mutableMetrics.updatePutJobTime(startTime);
            if (isUpdate) {
                this.listeners.onUpdateJob(jobSpec);
            } else {
                this.listeners.onAddJob(jobSpec);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("When persisting a new JobSpec, unexpected issues happen:" + e.getMessage());
        }
        catch (JobSpecNotFoundException e) {
            throw new RuntimeException("When replacing a existed JobSpec, unexpected issue happen:" + e.getMessage());
        }
    }

    @Override
    public synchronized void remove(URI jobURI) {
        Preconditions.checkState((this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)String.format("%s is not running.", this.getClass().getName()));
        try {
            long startTime = System.currentTimeMillis();
            JobSpec jobSpec = this.getJobSpec(jobURI);
            Path jobSpecPath = this.getPathForURI(this.jobConfDirPath, jobURI);
            if (this.fs.exists(jobSpecPath)) {
                this.fs.delete(jobSpecPath, false);
                this.mutableMetrics.updateRemoveJobTime(startTime);
            } else {
                LOGGER.warn("No file with URI:" + jobSpecPath + " is found. Deletion failed.");
            }
            this.listeners.onDeleteJob(jobURI, jobSpec.getVersion());
        }
        catch (IOException e) {
            throw new RuntimeException("When removing a JobConf. file, issues unexpected happen:" + e.getMessage());
        }
        catch (SpecNotFoundException e) {
            LOGGER.warn("No file with URI:" + jobURI + " is found. Deletion failed.");
        }
    }
}

