/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.instrumented.Instrumentable;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.instrumented.StandardMetricsBridge;
import org.apache.gobblin.metrics.ContextAwareGauge;
import org.apache.gobblin.metrics.ContextAwareTimer;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.api.JobCatalogListener;
import org.apache.gobblin.runtime.api.JobCatalogListenersContainer;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecNotFoundException;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public interface JobCatalog
extends JobCatalogListenersContainer,
Instrumentable,
StandardMetricsBridge {
    public Collection<JobSpec> getJobs();

    public StandardMetrics getMetrics();

    default public Collection<StandardMetricsBridge.StandardMetrics> getStandardMetricsCollection() {
        StandardMetrics standardMetrics = this.getMetrics();
        return standardMetrics == null ? ImmutableList.of() : ImmutableList.of((Object)standardMetrics);
    }

    public JobSpec getJobSpec(URI var1) throws JobSpecNotFoundException;

    public static class StandardMetrics
    extends StandardMetricsBridge.StandardMetrics
    implements JobCatalogListener {
        private static final Logger log = LoggerFactory.getLogger(StandardMetrics.class);
        public static final String NUM_ACTIVE_JOBS_NAME = "numActiveJobs";
        public static final String TOTAL_ADD_CALLS = "totalAddCalls";
        public static final String TOTAL_DELETE_CALLS = "totalDeleteCalls";
        public static final String TOTAL_UPDATE_CALLS = "totalUpdateCalls";
        public static final String TIME_FOR_JOB_CATALOG_GET = "timeForJobCatalogGet";
        public static final String TRACKING_EVENT_NAME = "JobCatalogEvent";
        public static final String JOB_ADDED_OPERATION_TYPE = "JobAdded";
        public static final String JOB_DELETED_OPERATION_TYPE = "JobDeleted";
        public static final String JOB_UPDATED_OPERATION_TYPE = "JobUpdated";
        private final MetricContext metricsContext;
        protected final int timeWindowSizeInMinutes;
        private final AtomicLong totalAddedJobs;
        private final AtomicLong totalDeletedJobs;
        private final AtomicLong totalUpdatedJobs;
        private final ContextAwareTimer timeForJobCatalogGet;
        private final ContextAwareGauge<Long> totalAddCalls;
        private final ContextAwareGauge<Long> totalDeleteCalls;
        private final ContextAwareGauge<Long> totalUpdateCalls;
        private final ContextAwareGauge<Integer> numActiveJobs;

        public StandardMetrics(JobCatalog jobCatalog, Optional<Config> sysConfig) {
            this.timeWindowSizeInMinutes = sysConfig.isPresent() ? ConfigUtils.getInt((Config)((Config)sysConfig.get()), (String)"metrics.timer.window.size.in.minutes", (Integer)15) : 15;
            this.metricsContext = jobCatalog.getMetricContext();
            this.totalAddedJobs = new AtomicLong(0L);
            this.totalDeletedJobs = new AtomicLong(0L);
            this.totalUpdatedJobs = new AtomicLong(0L);
            this.timeForJobCatalogGet = this.metricsContext.contextAwareTimer(TIME_FOR_JOB_CATALOG_GET, (long)this.timeWindowSizeInMinutes, TimeUnit.MINUTES);
            this.totalAddCalls = this.metricsContext.newContextAwareGauge(TOTAL_ADD_CALLS, () -> this.totalAddedJobs.get());
            this.totalUpdateCalls = this.metricsContext.newContextAwareGauge(TOTAL_UPDATE_CALLS, () -> this.totalUpdatedJobs.get());
            this.totalDeleteCalls = this.metricsContext.newContextAwareGauge(TOTAL_DELETE_CALLS, () -> this.totalDeletedJobs.get());
            this.numActiveJobs = this.metricsContext.newContextAwareGauge(NUM_ACTIVE_JOBS_NAME, () -> (int)(this.totalAddedJobs.get() - this.totalDeletedJobs.get()));
            this.contextAwareMetrics.add(this.timeForJobCatalogGet);
            this.contextAwareMetrics.add(this.totalAddCalls);
            this.contextAwareMetrics.add(this.totalDeleteCalls);
            this.contextAwareMetrics.add(this.totalUpdateCalls);
            this.contextAwareMetrics.add(this.numActiveJobs);
        }

        public void updateGetJobTime(long startTime) {
            log.info("updateGetJobTime...");
            Instrumented.updateTimer((Optional)Optional.of((Object)this.timeForJobCatalogGet), (long)(System.currentTimeMillis() - startTime), (TimeUnit)TimeUnit.MILLISECONDS);
        }

        @Override
        public void onAddJob(JobSpec addedJob) {
            this.totalAddedJobs.incrementAndGet();
            this.submitTrackingEvent(addedJob, JOB_ADDED_OPERATION_TYPE);
        }

        private void submitTrackingEvent(JobSpec job, String operType) {
            this.submitTrackingEvent(job.getUri(), job.getVersion(), operType);
        }

        private void submitTrackingEvent(URI jobSpecURI, String jobSpecVersion, String operType) {
            GobblinTrackingEvent e = GobblinTrackingEvent.newBuilder().setName(TRACKING_EVENT_NAME).setNamespace(JobCatalog.class.getName()).setMetadata((Map)ImmutableMap.builder().put((Object)"operationType", (Object)operType).put((Object)"jobSpecURI", (Object)jobSpecURI.toString()).put((Object)"jobSpecVersion", (Object)jobSpecVersion).build()).build();
            this.metricsContext.submitEvent(e);
        }

        @Override
        public void onDeleteJob(URI deletedJobURI, String deletedJobVersion) {
            this.totalDeletedJobs.incrementAndGet();
            this.submitTrackingEvent(deletedJobURI, deletedJobVersion, JOB_DELETED_OPERATION_TYPE);
        }

        @Override
        public void onUpdateJob(JobSpec updatedJob) {
            this.totalUpdatedJobs.incrementAndGet();
            this.submitTrackingEvent(updatedJob, JOB_UPDATED_OPERATION_TYPE);
        }

        public AtomicLong getTotalAddedJobs() {
            return this.totalAddedJobs;
        }

        public AtomicLong getTotalDeletedJobs() {
            return this.totalDeletedJobs;
        }

        public AtomicLong getTotalUpdatedJobs() {
            return this.totalUpdatedJobs;
        }

        public ContextAwareTimer getTimeForJobCatalogGet() {
            return this.timeForJobCatalogGet;
        }

        public ContextAwareGauge<Long> getTotalAddCalls() {
            return this.totalAddCalls;
        }

        public ContextAwareGauge<Long> getTotalDeleteCalls() {
            return this.totalDeleteCalls;
        }

        public ContextAwareGauge<Long> getTotalUpdateCalls() {
            return this.totalUpdateCalls;
        }

        public ContextAwareGauge<Integer> getNumActiveJobs() {
            return this.numActiveJobs;
        }
    }
}

