/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.stream.JsonWriter;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.StringMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.rest.JobExecutionInfo;
import org.apache.gobblin.rest.JobStateEnum;
import org.apache.gobblin.rest.LauncherTypeEnum;
import org.apache.gobblin.rest.Metric;
import org.apache.gobblin.rest.MetricArray;
import org.apache.gobblin.rest.MetricTypeEnum;
import org.apache.gobblin.rest.TaskExecutionInfoArray;
import org.apache.gobblin.runtime.JobLauncherFactory;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.api.MonitoredObject;
import org.apache.gobblin.runtime.util.JobMetrics;
import org.apache.gobblin.runtime.util.MetricGroup;
import org.apache.gobblin.util.ImmutableProperties;
import org.apache.hadoop.io.Text;

public class JobState
extends SourceState {
    private String jobName;
    private String jobId;
    private long startTime = 0L;
    private long endTime = 0L;
    private long duration = 0L;
    private RunningState state = RunningState.PENDING;
    private int taskCount = 0;
    private final Map<String, TaskState> taskStates = Maps.newLinkedHashMap();
    private final Map<String, TaskState> skippedTaskStates = Maps.newLinkedHashMap();
    private DatasetStateStore datasetStateStore;

    public JobState() {
    }

    public JobState(String jobName, String jobId) {
        this.jobName = jobName;
        this.jobId = jobId;
        this.setId(jobId);
    }

    public JobState(State properties, String jobName, String jobId) {
        super(properties);
        this.jobName = jobName;
        this.jobId = jobId;
        this.setId(jobId);
    }

    public JobState(State properties, Map<String, DatasetState> previousDatasetStates, String jobName, String jobId) {
        super(properties, previousDatasetStates, JobState.workUnitStatesFromDatasetStates(previousDatasetStates.values()));
        this.jobName = jobName;
        this.jobId = jobId;
        this.setId(jobId);
    }

    public static String getJobNameFromState(State state) {
        return state.getProp("job.name");
    }

    public static String getJobNameFromProps(Properties props) {
        return props.getProperty("job.name");
    }

    public static String getJobGroupFromState(State state) {
        return state.getProp("job.group");
    }

    public static String getJobGroupFromProps(Properties props) {
        return props.getProperty("job.group");
    }

    public static String getJobDescriptionFromProps(State state) {
        return state.getProp("job.description");
    }

    public static String getJobDescriptionFromProps(Properties props) {
        return props.getProperty("job.description");
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public synchronized RunningState getState() {
        return this.state;
    }

    public synchronized void setState(RunningState state) {
        this.state = state;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public void setTaskCount(int taskCount) {
        this.taskCount = taskCount;
    }

    public void incrementTaskCount() {
        ++this.taskCount;
    }

    public void addTaskState(TaskState taskState) {
        this.taskStates.put(taskState.getTaskId(), taskState);
    }

    public void addSkippedTaskState(TaskState taskState) {
        this.skippedTaskStates.put(taskState.getTaskId(), taskState);
    }

    public void removeTaskState(TaskState taskState) {
        this.taskStates.remove(taskState.getTaskId());
        --this.taskCount;
    }

    public void filterSkippedTaskStates() {
        ArrayList<TaskState> skippedTaskStates = new ArrayList<TaskState>();
        for (TaskState taskState : this.taskStates.values()) {
            if (taskState.getWorkingState() != WorkUnitState.WorkingState.SKIPPED) continue;
            skippedTaskStates.add(taskState);
        }
        for (TaskState taskState : skippedTaskStates) {
            this.removeTaskState(taskState);
            this.addSkippedTaskState(taskState);
        }
    }

    public void addTaskStates(Collection<TaskState> taskStates) {
        for (TaskState taskState : taskStates) {
            this.taskStates.put(taskState.getTaskId(), taskState);
        }
    }

    public void addSkippedTaskStates(Collection<TaskState> taskStates) {
        for (TaskState taskState : taskStates) {
            this.addSkippedTaskState(taskState);
        }
    }

    public int getCompletedTasks() {
        int completedTasks = 0;
        for (TaskState taskState : this.taskStates.values()) {
            if (!taskState.isCompleted()) continue;
            ++completedTasks;
        }
        return completedTasks;
    }

    public List<TaskState> getTaskStates() {
        return ImmutableList.builder().addAll(this.taskStates.values()).build();
    }

    public Map<String, DatasetState> createDatasetStatesByUrns() {
        String datasetUrn;
        HashMap datasetStatesByUrns = Maps.newHashMap();
        for (TaskState taskState : this.taskStates.values()) {
            datasetUrn = this.createDatasetUrn(datasetStatesByUrns, taskState);
            ((DatasetState)((Object)datasetStatesByUrns.get(datasetUrn))).incrementTaskCount();
            ((DatasetState)((Object)datasetStatesByUrns.get(datasetUrn))).addTaskState(taskState);
        }
        for (TaskState taskState : this.skippedTaskStates.values()) {
            datasetUrn = this.createDatasetUrn(datasetStatesByUrns, taskState);
            ((DatasetState)((Object)datasetStatesByUrns.get(datasetUrn))).addSkippedTaskState(taskState);
        }
        return ImmutableMap.copyOf((Map)datasetStatesByUrns);
    }

    private String createDatasetUrn(Map<String, DatasetState> datasetStatesByUrns, TaskState taskState) {
        String datasetUrn = taskState.getProp("dataset.urn", "");
        if (!datasetStatesByUrns.containsKey(datasetUrn)) {
            DatasetState datasetState = this.newDatasetState(false);
            datasetState.setDatasetUrn(datasetUrn);
            datasetStatesByUrns.put(datasetUrn, datasetState);
        }
        return datasetUrn;
    }

    public List<WorkUnitState> getTaskStatesAsWorkUnitStates() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TaskState taskState : this.taskStates.values()) {
            WorkUnitState workUnitState = new WorkUnitState(taskState.getWorkunit(), taskState.getJobState());
            workUnitState.setId(taskState.getId());
            workUnitState.addAll((State)taskState);
            builder.add((Object)workUnitState);
        }
        return builder.build();
    }

    public LauncherTypeEnum getLauncherType() {
        return (LauncherTypeEnum)Enums.getIfPresent(LauncherTypeEnum.class, (String)this.getProp("launcher.type", JobLauncherFactory.JobLauncherType.LOCAL.name())).or((Object)LauncherTypeEnum.LOCAL);
    }

    public void setJobLauncherType(LauncherTypeEnum jobLauncherType) {
        this.setProp("launcher.type", jobLauncherType.name());
    }

    public Optional<String> getTrackingURL() {
        return Optional.fromNullable((Object)this.getProp("job.tracking.url"));
    }

    public void readFields(DataInput in) throws IOException {
        Text text = new Text();
        text.readFields(in);
        this.jobName = text.toString().intern();
        text.readFields(in);
        this.jobId = text.toString().intern();
        this.setId(this.jobId);
        this.startTime = in.readLong();
        this.endTime = in.readLong();
        this.duration = in.readLong();
        text.readFields(in);
        this.state = RunningState.valueOf(text.toString());
        this.taskCount = in.readInt();
        int numTaskStates = in.readInt();
        this.getTaskStateWithCommonAndSpecWuProps(numTaskStates, in);
        super.readFields(in);
    }

    private void getTaskStateWithCommonAndSpecWuProps(int numTaskStates, DataInput in) throws IOException {
        Properties commonWuProps = new Properties();
        for (int i = 0; i < numTaskStates; ++i) {
            TaskState taskState = new TaskState();
            taskState.readFields(in);
            if (i == 0) {
                commonWuProps.putAll((Map<?, ?>)taskState.getWorkunit().getProperties());
            } else {
                Properties newCommonWuProps = new Properties();
                newCommonWuProps.putAll((Map<?, ?>)Maps.difference((Map)commonWuProps, (Map)taskState.getWorkunit().getProperties()).entriesInCommon());
                commonWuProps = newCommonWuProps;
            }
            this.taskStates.put(taskState.getTaskId().intern(), taskState);
        }
        ImmutableProperties immutableCommonProperties = new ImmutableProperties(commonWuProps);
        for (TaskState taskState : this.taskStates.values()) {
            Properties newSpecProps = new Properties();
            newSpecProps.putAll((Map<?, ?>)Maps.difference((Map)immutableCommonProperties, (Map)taskState.getWorkunit().getProperties()).entriesOnlyOnRight());
            taskState.setWuProperties((Properties)immutableCommonProperties, newSpecProps);
        }
    }

    public void write(DataOutput out) throws IOException {
        this.write(out, true, true);
    }

    public void write(DataOutput out, boolean writeTasks, boolean writePreviousWorkUnitStates) throws IOException {
        Text text = new Text();
        text.set(this.jobName);
        text.write(out);
        text.set(this.jobId);
        text.write(out);
        out.writeLong(this.startTime);
        out.writeLong(this.endTime);
        out.writeLong(this.duration);
        text.set(this.state.name());
        text.write(out);
        out.writeInt(this.taskCount);
        if (writeTasks) {
            out.writeInt(this.taskStates.size() + this.skippedTaskStates.size());
            for (TaskState taskState : this.taskStates.values()) {
                taskState.write(out);
            }
            for (TaskState taskState : this.skippedTaskStates.values()) {
                taskState.write(out);
            }
        } else {
            out.writeInt(0);
        }
        super.write(out, writePreviousWorkUnitStates);
    }

    public void toJson(JsonWriter jsonWriter, boolean keepConfig) throws IOException {
        jsonWriter.beginObject();
        this.writeStateSummary(jsonWriter);
        jsonWriter.name("task states");
        jsonWriter.beginArray();
        for (TaskState taskState : this.taskStates.values()) {
            taskState.toJson(jsonWriter, keepConfig);
        }
        for (TaskState taskState : this.skippedTaskStates.values()) {
            taskState.toJson(jsonWriter, keepConfig);
        }
        jsonWriter.endArray();
        if (keepConfig) {
            jsonWriter.name("properties");
            this.propsToJson(jsonWriter);
        }
        jsonWriter.endObject();
    }

    protected void writeStateSummary(JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("job name").value(this.getJobName()).name("job id").value(this.getJobId()).name("job state").value(this.getState().name()).name("start time").value(this.getStartTime()).name("end time").value(this.getEndTime()).name("duration").value(this.getDuration()).name("tasks").value((long)this.getTaskCount()).name("completed tasks").value((long)this.getCompletedTasks());
    }

    protected void propsToJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginObject();
        for (String key : this.getPropertyNames()) {
            jsonWriter.name(key).value(this.getProp(key));
        }
        jsonWriter.endObject();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JobState)) {
            return false;
        }
        JobState other = (JobState)((Object)object);
        return super.equals((Object)other) && this.jobName.equals(other.jobName) && this.jobId.equals(other.jobId);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.jobName.hashCode();
        result = 31 * result + this.jobId.hashCode();
        return result;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);){
            jsonWriter.setIndent("\t");
            this.toJson(jsonWriter, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public JobExecutionInfo toJobExecutionInfo() {
        JobExecutionInfo jobExecutionInfo = new JobExecutionInfo();
        jobExecutionInfo.setJobName(this.jobName);
        jobExecutionInfo.setJobId(this.jobId);
        if (this.startTime > 0L) {
            jobExecutionInfo.setStartTime(this.startTime);
        }
        if (this.endTime > 0L) {
            jobExecutionInfo.setEndTime(this.endTime);
        }
        jobExecutionInfo.setDuration(this.duration);
        jobExecutionInfo.setState(JobStateEnum.valueOf((String)this.state.name()));
        jobExecutionInfo.setLaunchedTasks(this.taskCount);
        jobExecutionInfo.setCompletedTasks(this.getCompletedTasks());
        jobExecutionInfo.setLauncherType(this.getLauncherType());
        if (this.getTrackingURL().isPresent()) {
            jobExecutionInfo.setTrackingUrl((String)this.getTrackingURL().get());
        }
        TaskExecutionInfoArray taskExecutionInfos = new TaskExecutionInfoArray();
        for (TaskState taskState : this.getTaskStates()) {
            taskExecutionInfos.add((DataTemplate)taskState.toTaskExecutionInfo());
        }
        jobExecutionInfo.setTaskExecutions(taskExecutionInfos);
        JobMetrics jobMetrics = JobMetrics.get(this);
        MetricArray metricArray = new MetricArray();
        for (Map.Entry entry : jobMetrics.getMetricContext().getCounters().entrySet()) {
            Metric counter = new Metric();
            counter.setGroup(MetricGroup.JOB.name());
            counter.setName((String)entry.getKey());
            counter.setType(MetricTypeEnum.valueOf((String)GobblinMetrics.MetricType.COUNTER.name()));
            counter.setValue(Long.toString(((Counter)entry.getValue()).getCount()));
            metricArray.add((DataTemplate)counter);
        }
        for (Map.Entry entry : jobMetrics.getMetricContext().getMeters().entrySet()) {
            Metric meter = new Metric();
            meter.setGroup(MetricGroup.JOB.name());
            meter.setName((String)entry.getKey());
            meter.setType(MetricTypeEnum.valueOf((String)GobblinMetrics.MetricType.METER.name()));
            meter.setValue(Double.toString(((Meter)entry.getValue()).getMeanRate()));
            metricArray.add((DataTemplate)meter);
        }
        for (Map.Entry entry : jobMetrics.getMetricContext().getGauges().entrySet()) {
            Metric gauge = new Metric();
            gauge.setGroup(MetricGroup.JOB.name());
            gauge.setName((String)entry.getKey());
            gauge.setType(MetricTypeEnum.valueOf((String)GobblinMetrics.MetricType.GAUGE.name()));
            gauge.setValue(((Gauge)entry.getValue()).getValue().toString());
            metricArray.add((DataTemplate)gauge);
        }
        jobExecutionInfo.setMetrics(metricArray);
        HashMap jobProperties = Maps.newHashMap();
        for (String name : this.getPropertyNames()) {
            String value = this.getProp(name);
            if (Strings.isNullOrEmpty((String)value)) continue;
            jobProperties.put(name, value);
        }
        jobExecutionInfo.setJobProperties(new StringMap((Map)jobProperties));
        return jobExecutionInfo;
    }

    public DatasetState newDatasetState(boolean fullCopy) {
        DatasetState datasetState = new DatasetState(this.jobName, this.jobId);
        datasetState.setStartTime(this.startTime);
        datasetState.setEndTime(this.endTime);
        datasetState.setDuration(this.duration);
        if (fullCopy) {
            datasetState.setState(this.state);
            datasetState.setTaskCount(this.taskCount);
            datasetState.addTaskStates(this.taskStates.values());
            datasetState.addSkippedTaskStates(this.skippedTaskStates.values());
        }
        return datasetState;
    }

    public static List<WorkUnitState> workUnitStatesFromDatasetStates(Iterable<DatasetState> datasetStates) {
        ImmutableList.Builder taskStateBuilder = ImmutableList.builder();
        for (JobState jobState : datasetStates) {
            taskStateBuilder.addAll(jobState.getTaskStatesAsWorkUnitStates());
        }
        return taskStateBuilder.build();
    }

    public static class DatasetState
    extends JobState {
        public DatasetState() {
        }

        public DatasetState(String jobName, String jobId) {
            super(jobName, jobId);
        }

        public void setDatasetUrn(String datasetUrn) {
            super.setProp("dataset.urn", (Object)datasetUrn);
        }

        public String getDatasetUrn() {
            return super.getProp("dataset.urn", "");
        }

        public void incrementJobFailures() {
            super.setProp("job.failures", (Object)(Integer.parseInt(super.getProp("job.failures", "0")) + 1));
        }

        public void setNoJobFailure() {
            super.setProp("job.failures", (Object)0);
        }

        public int getJobFailures() {
            return Integer.parseInt(super.getProp("job.failures"));
        }

        @Override
        protected void propsToJson(JsonWriter jsonWriter) throws IOException {
            jsonWriter.beginObject();
            jsonWriter.name("dataset.urn").value(this.getDatasetUrn());
            jsonWriter.name("job.failures").value((long)this.getJobFailures());
            jsonWriter.endObject();
        }

        public String getProp(String key) {
            throw new UnsupportedOperationException();
        }

        public String getProp(String key, String def) {
            throw new UnsupportedOperationException();
        }

        public void setProp(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void addAll(Properties properties) {
            throw new UnsupportedOperationException();
        }

        public void addAllIfNotExist(Properties properties) {
            throw new UnsupportedOperationException();
        }

        public void overrideWith(Properties properties) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void writeStateSummary(JsonWriter jsonWriter) throws IOException {
            super.writeStateSummary(jsonWriter);
            jsonWriter.name("datasetUrn").value(this.getDatasetUrn());
        }
    }

    public static enum RunningState implements MonitoredObject
    {
        PENDING,
        RUNNING,
        SUCCESSFUL,
        COMMITTED,
        FAILED,
        CANCELLED;


        public boolean isCancelled() {
            return this.equals(CANCELLED);
        }

        public boolean isDone() {
            return this.equals(COMMITTED) || this.equals(FAILED) || this.equals(CANCELLED);
        }

        public boolean isSuccess() {
            return this.equals(COMMITTED);
        }

        public boolean isFailure() {
            return this.equals(FAILED);
        }

        public boolean isRunningOrDone() {
            return this.isDone() || this.equals(RUNNING);
        }
    }
}

