/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import java.util.List;
import org.apache.gobblin.runtime.TaskState;

public class EventMetadataUtils {
    public static final String TASK_FAILURE_MESSAGE_KEY = "task.failure.message";

    public static long getProcessedCount(List<TaskState> taskStates) {
        long value = 0L;
        for (TaskState taskState : taskStates) {
            value += taskState.getPropAsLong("writer.records.written", 0L);
        }
        return value;
    }

    public static String getTaskFailureExceptions(List<TaskState> taskStates) {
        StringBuffer sb = new StringBuffer();
        EventMetadataUtils.appendTaskStateValues(taskStates, sb, TASK_FAILURE_MESSAGE_KEY);
        EventMetadataUtils.appendTaskStateValues(taskStates, sb, "task.failure.exception");
        return sb.toString();
    }

    private static void appendTaskStateValues(List<TaskState> taskStates, StringBuffer sb, String key) {
        for (TaskState taskState : taskStates) {
            if (!taskState.contains(key)) continue;
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(taskState.getProp(key));
        }
    }
}

