/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.commit;

import com.google.common.base.Preconditions;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.commit.CommitSequence;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.commit.CommitStepBase;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.util.ClassAliasResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class DatasetStateCommitStep
extends CommitStepBase {
    private static final Logger log = LoggerFactory.getLogger(DatasetStateCommitStep.class);
    private final String datasetUrn;
    private final JobState.DatasetState datasetState;
    private transient DatasetStateStore stateStore;

    private DatasetStateCommitStep(Builder<? extends Builder<?>> builder) {
        super(builder);
        this.datasetUrn = ((Builder)builder).datasetUrn;
        this.datasetState = ((Builder)builder).datasetState;
    }

    public boolean isCompleted() throws IOException {
        Preconditions.checkNotNull((Object)((Object)this.datasetState));
        return this.datasetState.equals(this.getDatasetStateStore().getLatestDatasetState(this.datasetState.getJobName(), this.datasetUrn));
    }

    public void execute() throws IOException {
        log.info("Persisting dataset state for dataset " + this.datasetUrn);
        this.getDatasetStateStore().persistDatasetState(this.datasetUrn, (State)this.datasetState);
    }

    private DatasetStateStore getDatasetStateStore() throws IOException {
        if (this.stateStore == null) {
            ClassAliasResolver resolver = new ClassAliasResolver(DatasetStateStore.Factory.class);
            String stateStoreType = this.props.getProp("dataset.state.store.type", this.props.getProp("state.store.type", "fs"));
            try {
                DatasetStateStore.Factory stateStoreFactory = (DatasetStateStore.Factory)resolver.resolveClass(stateStoreType).newInstance();
                this.stateStore = stateStoreFactory.createStateStore(ConfigFactory.parseProperties((Properties)this.props.getProperties()));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return this.stateStore;
    }

    public static class Builder<T extends Builder<?>>
    extends CommitStepBase.Builder<T> {
        private String datasetUrn;
        private JobState.DatasetState datasetState;

        public Builder() {
        }

        public Builder(CommitSequence.Builder commitSequenceBuilder) {
            super(commitSequenceBuilder);
        }

        public T withDatasetUrn(String datasetUrn) {
            this.datasetUrn = datasetUrn;
            return (T)((Object)this);
        }

        public T withDatasetState(JobState.DatasetState datasetState) {
            this.datasetState = datasetState;
            return (T)((Object)this);
        }

        public CommitStep build() {
            Preconditions.checkNotNull((Object)this.datasetUrn);
            Preconditions.checkNotNull((Object)((Object)this.datasetState));
            return new DatasetStateCommitStep(this);
        }
    }
}

