/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.configuration.CombinedWorkUnitAndDatasetState;
import org.apache.gobblin.configuration.CombinedWorkUnitAndDatasetStateFunctional;
import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.runtime.JobState;

public class CombinedWorkUnitAndDatasetStateGenerator
implements CombinedWorkUnitAndDatasetStateFunctional {
    private DatasetStateStore datasetStateStore;
    private String jobName;

    public CombinedWorkUnitAndDatasetStateGenerator(DatasetStateStore datasetStateStore, String jobName) {
        this.datasetStateStore = datasetStateStore;
        this.jobName = jobName;
    }

    public CombinedWorkUnitAndDatasetState getCombinedWorkUnitAndDatasetState(String datasetUrn) throws Exception {
        Object datasetStateMap = ImmutableMap.of();
        List<Object> workUnitStates = new ArrayList();
        if (Strings.isNullOrEmpty((String)datasetUrn)) {
            datasetStateMap = this.datasetStateStore.getLatestDatasetStatesByUrns(this.jobName);
            workUnitStates = JobState.workUnitStatesFromDatasetStates(datasetStateMap.values());
        } else {
            JobState.DatasetState datasetState = (JobState.DatasetState)this.datasetStateStore.getLatestDatasetState(this.jobName, datasetUrn);
            if (datasetState != null) {
                datasetStateMap = ImmutableMap.of((Object)datasetUrn, (Object)((Object)datasetState));
                workUnitStates = JobState.workUnitStatesFromDatasetStates(Arrays.asList(datasetState));
            }
        }
        return new CombinedWorkUnitAndDatasetState(workUnitStates, (Map)datasetStateMap);
    }
}

