/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.spec_executorInstance;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.AbstractIdleService;
import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.ServiceNode;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.api.SpecProducer;
import org.apache.gobblin.runtime.spec_executorInstance.BaseServiceNodeImpl;
import org.apache.gobblin.util.CompletedFuture;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpecExecutor
extends AbstractIdleService
implements SpecExecutor {
    private static final Splitter SPLIT_BY_COMMA = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private static final Splitter SPLIT_BY_COLON = Splitter.on((String)":").omitEmptyStrings().trimResults();
    protected final transient Logger log;
    protected final URI specExecutorInstanceUri;
    @SuppressWarnings(justification="No bug", value={"SE_BAD_FIELD"})
    protected final Config config;
    protected final Map<ServiceNode, ServiceNode> capabilities;
    protected Optional<Closer> optionalCloser;

    public AbstractSpecExecutor(Config config) {
        this(config, (Optional<Logger>)Optional.absent());
    }

    public AbstractSpecExecutor(Config config, GobblinInstanceEnvironment env) {
        this(config, (Optional<Logger>)Optional.of((Object)env.getLog()));
    }

    public AbstractSpecExecutor(Config config, Optional<Logger> log) {
        if (!config.hasPath("specExecInstance.uri") && log.isPresent()) {
            ((Logger)log.get()).warn("The SpecExecutor doesn't specify URI, using the default one.");
        }
        try {
            this.specExecutorInstanceUri = new URI(ConfigUtils.getString((Config)config, (String)"specExecInstance.uri", (String)"NA"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.log = log.isPresent() ? (Logger)log.get() : LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.config = config;
        this.capabilities = Maps.newHashMap();
        if (config.hasPath("specExecInstance.capabilities")) {
            String capabilitiesStr = config.getString("specExecInstance.capabilities");
            List capabilities = SPLIT_BY_COMMA.splitToList((CharSequence)capabilitiesStr);
            for (String capability : capabilities) {
                List currentCapability = SPLIT_BY_COLON.splitToList((CharSequence)capability);
                Preconditions.checkArgument((currentCapability.size() == 2 ? 1 : 0) != 0, (Object)("Only one source:destination pair is supported per capability, found: " + currentCapability));
                this.capabilities.put(new BaseServiceNodeImpl((String)currentCapability.get(0)), new BaseServiceNodeImpl((String)currentCapability.get(1)));
            }
        }
        this.optionalCloser = Optional.absent();
    }

    public URI getUri() {
        return this.specExecutorInstanceUri;
    }

    public Config getAttrs() {
        Preconditions.checkArgument((boolean)this.config.hasPath("executorAttrs"), (Object)"Input configuration doesn't contains SpecExecutor Attributes path.");
        return this.config.getConfig("executorAttrs");
    }

    public Future<Config> getConfig() {
        return new CompletedFuture((Object)this.config, null);
    }

    public Future<? extends Map<ServiceNode, ServiceNode>> getCapabilities() {
        return new CompletedFuture(this.capabilities, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractSpecExecutor that = (AbstractSpecExecutor)((Object)o);
        return this.specExecutorInstanceUri.equals(that.specExecutorInstanceUri);
    }

    public int hashCode() {
        return this.specExecutorInstanceUri.hashCode();
    }

    public Future<String> getHealth() {
        return new CompletedFuture((Object)"Healthy", null);
    }

    protected abstract void startUp() throws Exception;

    protected abstract void shutDown() throws Exception;

    public abstract Future<? extends SpecProducer> getProducer();

    public abstract Future<String> getDescription();
}

