/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Enums;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.fork.ForkOperator;
import org.apache.gobblin.instrumented.converter.InstrumentedConverterDecorator;
import org.apache.gobblin.instrumented.fork.InstrumentedForkOperatorDecorator;
import org.apache.gobblin.publisher.TaskPublisher;
import org.apache.gobblin.publisher.TaskPublisherBuilderFactory;
import org.apache.gobblin.qualitychecker.row.RowLevelPolicyChecker;
import org.apache.gobblin.qualitychecker.row.RowLevelPolicyCheckerBuilderFactory;
import org.apache.gobblin.qualitychecker.task.TaskLevelPolicyCheckResults;
import org.apache.gobblin.qualitychecker.task.TaskLevelPolicyChecker;
import org.apache.gobblin.qualitychecker.task.TaskLevelPolicyCheckerBuilderFactory;
import org.apache.gobblin.records.RecordStreamProcessor;
import org.apache.gobblin.runtime.LimitingExtractorDecorator;
import org.apache.gobblin.runtime.StateStoreBasedWatermarkStorage;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.util.TaskMetrics;
import org.apache.gobblin.source.Source;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.util.limiter.DefaultLimiterFactory;
import org.apache.gobblin.util.limiter.Limiter;
import org.apache.gobblin.util.limiter.NonRefillableLimiter;
import org.apache.gobblin.writer.DataWriterBuilder;
import org.apache.gobblin.writer.Destination;
import org.apache.gobblin.writer.WatermarkStorage;
import org.apache.gobblin.writer.WriterOutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskContext {
    private static final Logger log = LoggerFactory.getLogger(TaskContext.class);
    private final TaskState taskState;
    private final TaskMetrics taskMetrics;
    private Extractor rawSourceExtractor;

    public TaskContext(WorkUnitState workUnitState) {
        this.taskState = new TaskState(workUnitState);
        this.taskMetrics = TaskMetrics.get(this.taskState);
        this.taskState.setProp("metrics.context.name", this.taskMetrics.getName());
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public TaskMetrics getTaskMetrics() {
        return this.taskMetrics;
    }

    public Source getSource() {
        try {
            return (Source)Source.class.cast(Class.forName(this.taskState.getProp("source.class")).newInstance());
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public Extractor getExtractor() {
        try {
            this.rawSourceExtractor = this.getSource().getExtractor((WorkUnitState)this.taskState);
            boolean throttlingEnabled = this.taskState.getPropAsBoolean("extract.limit.enabled", false);
            if (throttlingEnabled) {
                Limiter limiter = DefaultLimiterFactory.newLimiter((State)this.taskState);
                if (!(limiter instanceof NonRefillableLimiter)) {
                    throw new IllegalArgumentException("The Limiter used with an Extractor should be an instance of " + NonRefillableLimiter.class.getSimpleName());
                }
                return new LimitingExtractorDecorator(this.rawSourceExtractor, limiter, this.taskState);
            }
            return this.rawSourceExtractor;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public Extractor getRawSourceExtractor() {
        return this.rawSourceExtractor;
    }

    public long getStatusReportingInterval() {
        return this.taskState.getPropAsLong("task.status.reportintervalinms", 30000L);
    }

    public Destination.DestinationType getDestinationType(int branches, int index) {
        return Destination.DestinationType.valueOf((String)this.taskState.getProp(ForkOperatorUtils.getPropertyNameForBranch((String)"writer.destination.type", (int)branches, (int)index), Destination.DestinationType.HDFS.name()));
    }

    public WriterOutputFormat getWriterOutputFormat(int branches, int index) {
        String writerOutputFormatValue = this.taskState.getProp(ForkOperatorUtils.getPropertyNameForBranch((String)"writer.output.format", (int)branches, (int)index), WriterOutputFormat.OTHER.name());
        log.debug("Found writer output format value = {}", (Object)writerOutputFormatValue);
        WriterOutputFormat wof = (WriterOutputFormat)Enums.getIfPresent(WriterOutputFormat.class, (String)writerOutputFormatValue.toUpperCase()).or((Object)WriterOutputFormat.OTHER);
        log.debug("Returning writer output format = {}", (Object)wof);
        return wof;
    }

    public List<Converter<?, ?, ?, ?>> getConverters() {
        return this.getConverters(-1, this.taskState);
    }

    public List<Converter<?, ?, ?, ?>> getConverters(int index, TaskState forkTaskState) {
        String converterClassKey = ForkOperatorUtils.getPropertyNameForBranch((String)"converter.classes", (int)index);
        if (!this.taskState.contains(converterClassKey)) {
            return Collections.emptyList();
        }
        if (index >= 0) {
            forkTaskState.setProp("fork.branch.id", index);
        }
        ArrayList converters = Lists.newArrayList();
        for (String converterClass : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)this.taskState.getProp(converterClassKey))) {
            try {
                Converter converter = (Converter)Converter.class.cast(Class.forName(converterClass).newInstance());
                InstrumentedConverterDecorator instrumentedConverter = new InstrumentedConverterDecorator(converter);
                instrumentedConverter.init((WorkUnitState)forkTaskState);
                converters.add(instrumentedConverter);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
        }
        return converters;
    }

    public List<RecordStreamProcessor<?, ?, ?, ?>> getRecordStreamProcessors() {
        return this.getRecordStreamProcessors(-1, this.taskState);
    }

    public List<RecordStreamProcessor<?, ?, ?, ?>> getRecordStreamProcessors(int index, TaskState forkTaskState) {
        String streamProcessorClassKey = ForkOperatorUtils.getPropertyNameForBranch((String)"recordStreamProcessor.classes", (int)index);
        if (!this.taskState.contains(streamProcessorClassKey)) {
            return Collections.emptyList();
        }
        if (index >= 0) {
            forkTaskState.setProp("fork.branch.id", index);
        }
        ArrayList streamProcessors = Lists.newArrayList();
        for (String streamProcessorClass : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)this.taskState.getProp(streamProcessorClassKey))) {
            try {
                RecordStreamProcessor streamProcessor = (RecordStreamProcessor)RecordStreamProcessor.class.cast(Class.forName(streamProcessorClass).newInstance());
                if (streamProcessor instanceof Converter) {
                    InstrumentedConverterDecorator instrumentedConverter = new InstrumentedConverterDecorator((Converter)streamProcessor);
                    instrumentedConverter.init((WorkUnitState)forkTaskState);
                    streamProcessors.add(instrumentedConverter);
                    continue;
                }
                streamProcessors.add(streamProcessor);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
        }
        return streamProcessors;
    }

    public ForkOperator getForkOperator() {
        try {
            ForkOperator fork = (ForkOperator)ForkOperator.class.cast(Class.forName(this.taskState.getProp("fork.operator.class", "org.apache.gobblin.fork.IdentityForkOperator")).newInstance());
            return new InstrumentedForkOperatorDecorator(fork);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public RowLevelPolicyChecker getRowLevelPolicyChecker() throws Exception {
        return this.getRowLevelPolicyChecker(-1);
    }

    public RowLevelPolicyChecker getRowLevelPolicyChecker(int index) throws Exception {
        return RowLevelPolicyCheckerBuilderFactory.newPolicyCheckerBuilder((State)this.taskState, (int)index).build();
    }

    public TaskLevelPolicyChecker getTaskLevelPolicyChecker(TaskState taskState, int index) throws Exception {
        return TaskLevelPolicyCheckerBuilderFactory.newPolicyCheckerBuilder((State)taskState, (int)index).build();
    }

    public TaskPublisher getTaskPublisher(TaskState taskState, TaskLevelPolicyCheckResults results) throws Exception {
        return TaskPublisherBuilderFactory.newTaskPublisherBuilder((WorkUnitState)taskState, (TaskLevelPolicyCheckResults)results).build();
    }

    public DataWriterBuilder getDataWriterBuilder(int branches, int index) {
        String writerBuilderPropertyName = ForkOperatorUtils.getPropertyNameForBranch((String)"writer.builder.class", (int)branches, (int)index);
        log.debug("Using property {} to get a writer builder for branches:{}, index:{}", new Object[]{writerBuilderPropertyName, branches, index});
        String dataWriterBuilderClassName = this.taskState.getProp(writerBuilderPropertyName, null);
        if (dataWriterBuilderClassName == null) {
            dataWriterBuilderClassName = "org.apache.gobblin.writer.AvroDataWriterBuilder";
            log.info("No configured writer builder found, using {} as the default builder", (Object)dataWriterBuilderClassName);
        } else {
            log.info("Found configured writer builder as {}", (Object)dataWriterBuilderClassName);
        }
        try {
            return (DataWriterBuilder)DataWriterBuilder.class.cast(Class.forName(dataWriterBuilderClassName).newInstance());
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public WatermarkStorage getWatermarkStorage() {
        return new StateStoreBasedWatermarkStorage((State)this.taskState);
    }
}

